Rkns.Wikipedia = {
};

Rkns.Wikipedia.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "en";
};

Rkns.Wikipedia.Search.prototype.getBgClass = function() {
    return "Rk-Wikipedia-Search-Icon Rk-Wikipedia-Lang-" + this.lang;
};

Rkns.Wikipedia.Search.prototype.getSearchTitle = function() {
    var langs = {
        "fr": "French",
        "en": "English",
        "ja": "Japanese"
    };
    if (langs[this.lang]) {
        return this.renkan.translate("Wikipedia in ") + this.renkan.translate(langs[this.lang]);
    } else {
        return this.renkan.translate("Wikipedia") + " [" + this.lang + "]";
    }
};

Rkns.Wikipedia.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.Wikipedia.Bin(this.renkan, {
            lang: this.lang,
            search: _q
        })
    );
};

Rkns.Wikipedia.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.Wikipedia.Bin.prototype.resultTemplate = Rkns._.template(
    '<li class="Rk-Wikipedia-Result Rk-Bin-Item" draggable="true" data-uri="<%-url%>" '
    + 'data-title="Wikipedia: <%-title%>" data-description="<%-description%>" data-image="<%- Rkns.Utils.getFullURL( static_url + \'img/wikipedia.png\' ) %>">'
    + '<img class="Rk-Wikipedia-Icon" src="<%-static_url%>img/wikipedia.png"></div><h4 class="Rk-Wikipedia-Title"><a href="<%-url%>" target="_blank"><%=htitle%></a></h4>'
    + '<p class="Rk-Wikipedia-Snippet"><%=hdescription%></p></li>'
);

Rkns.Wikipedia.Bin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.search = _opts.search;
    this.lang = _opts.lang || "en";
    this.title_icon_$.addClass('Rk-Wikipedia-Title-Icon Rk-Wikipedia-Lang-' + this.lang);
    this.title_$.html(this.search).addClass("Rk-Wikipedia-Title");
    this.refresh();
};

Rkns.Wikipedia.Bin.prototype.render = function(searchstr) {
    var _rgxp = new RegExp('('+(searchstr || this.search).replace(/(\W)/g,'\\$1')+')','gi');
    if (searchstr) {
        var rxtest = new RegExp(searchstr.replace(/(\W)/g,'\\$1'),'i');
    }
    function highlight(_text) {
        return _text.replace(_rgxp, "<span class='searchmatch'>$1</span>");
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._(this.data.query.search).each(function(_result) {
        var title = _result.title,
            url = "http://" + _this.lang + ".wikipedia.org/wiki/" + encodeURI(title.replace(/ /g,"_")),
            description = Rkns.$('<div>').html(_result.snippet).text();
        if (searchstr && !rxtest.test(title) && !rxtest.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            description: description,
            hdescription: highlight(description),
            static_url: _this.renkan.options.static_url
        });
    });
    _this.main_$.html(_html);
    if (searchstr && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (searchstr && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};
    
Rkns.Wikipedia.Bin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: "http://" + _this.lang + ".wikipedia.org/w/api.php?action=query&list=search&srsearch=" + encodeURIComponent(this.search) + "&format=json",
        dataType: "jsonp",
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
};