from django.conf.urls import include, url
from django.contrib import admin
from renkanmanager.api.views import RenkanList, RenkanDetail, WorkspaceList, WorkspaceDetail, RevisionList, RevisionDetail

urlpatterns = [
    url(r'^renkans/$', RenkanList.as_view(), name='renkan_list'),
    url(r'^workspaces/(?P<workspace_guid>[\w-]+)/renkans/$', RenkanList.as_view(), name='renkan_list_workspace'),
    url(r'^renkans/(?P<renkan_guid>[\w-]+)/?$', RenkanDetail.as_view(), name='renkan_detail'),
    url(r'^workspaces/$', WorkspaceList.as_view(), name='workspace_list'),
    url(r'^workspaces/(?P<workspace_guid>[\w-]+)/?$', WorkspaceDetail.as_view(), name='workspace_detail'),
    url(r'^renkans/(?P<renkan_guid>[\w-]+)/revisions/$', RevisionList.as_view(), name='revision_list'),
    url(r'^renkans/(?P<renkan_guid>[\w-]+)/revisions/(?P<revision_guid>[\w-]+)/?$', RevisionDetail.as_view(), name='revision_detail')
]