Rkns.Renderers.Paper = Rkns.Utils.inherit(Rkns.Renderers._Base);

Rkns.Renderers.Paper__Utils = {
    _EDITOR_ARROW_LENGTH : 20,
    _EDITOR_ARROW_WIDTH : 40,
    _EDITOR_MARGIN : 15,
    _EDITOR_PADDING : 10,
    _EDITOR_GRADIENT : new paper.Gradient(['#f0f0f0', '#d0d0d0']),
    drawEditBox : function(_coords, _path, _width, _height) {
        var _isLeft = (_coords.x < paper.view.center.x ? 1 : -1),
            _left = _coords.x + _isLeft * ( this._EDITOR_MARGIN + this._EDITOR_ARROW_LENGTH ),
            _right = _coords.x + _isLeft * ( this._EDITOR_MARGIN + this._EDITOR_ARROW_LENGTH + _width ),
            _top = _coords.y - _height / 2;
        if (_top < this._EDITOR_MARGIN) {
            _top = Math.min( this._EDITOR_MARGIN, _coords.y - this._EDITOR_ARROW_WIDTH / 2 );
        }
        var _bottom = _top + _height;
        if (_bottom > (paper.view.size.height - this._EDITOR_MARGIN)) {
            _bottom = Math.max( paper.view.size.height - this._EDITOR_MARGIN, _coords.y + this._EDITOR_ARROW_WIDTH / 2 );
            _top = _bottom - _height;
        }
        _path.segments[0].point
            = _path.segments[7].point
            = _coords.add([_isLeft * this._EDITOR_MARGIN, 0]);
        _path.segments[1].point.x
            = _path.segments[2].point.x
            = _path.segments[5].point.x
            = _path.segments[6].point.x
            = _left;
        _path.segments[3].point.x
            = _path.segments[4].point.x
            = _right;
        _path.segments[2].point.y
            = _path.segments[3].point.y
            = _top;
        _path.segments[4].point.y
            = _path.segments[5].point.y
            = _bottom;
        _path.segments[1].point.y = _coords.y - this._EDITOR_ARROW_WIDTH / 2;
        _path.segments[6].point.y = _coords.y + this._EDITOR_ARROW_WIDTH / 2;
        _path.fillColor = new paper.GradientColor(this._EDITOR_GRADIENT, [0,_top], [0, _bottom])
        return {
            left: (this._EDITOR_PADDING + Math.min(_left, _right)),
            top: (this._EDITOR_PADDING + _top)
        }
    }
}

Rkns.Renderers.Paper__Controllers = {}

Rkns.Renderers.Paper__Controllers._Base = function(_renderer, _element) {
    if (typeof _renderer !== "undefined") {
        this.id = Rkns.Utils.getUID('controller');
        this._renderer = _renderer;
        this._project = _renderer._project;
        this._element = _element;
        this._element.__controller = this;
    }
}

Rkns.Renderers.Paper__Controllers._Base.prototype.select = function() {}

Rkns.Renderers.Paper__Controllers._Base.prototype.unselect = function() {}

Rkns.Renderers.Paper__Controllers._Base.prototype.destroy = function() {}

Rkns.Renderers.Paper__Controllers.Node = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.Node.prototype._init = function() {
    this._renderer.node_layer.activate();
    this.type = "node";
    this.node_circle = new paper.Path.Circle([0, 0], Rkns._NODE_RADIUS);
    this.node_circle.fillColor = '#ffffff';
    this.node_circle.__controller = this;
    this.node_text = new paper.PointText([0,0]);
    this.node_text.characterStyle = {
        fontSize: Rkns._NODE_FONT_SIZE,
        fillColor: 'black'
    };
    this.node_text.paragraphStyle.justification = 'center';
    this.node_text.__controller = this;
}

Rkns.Renderers.Paper__Controllers.Node.prototype.redraw = function() {
    this.node_model_coords = new paper.Point(this._element.position);
    this.node_paper_coords = this._renderer.toPaperCoords(this.node_model_coords);
    this.node_circle.position = this.node_paper_coords;
    this.node_text.content = this._element.title;
    this.node_text.position = this.node_paper_coords.add([0, 2 * Rkns._NODE_RADIUS]);
    this.node_circle.strokeColor = this._element.created_by.color;
}

Rkns.Renderers.Paper__Controllers.Node.prototype.paperShift = function(_delta) {
    var _coords = this._renderer.toModelCoords(this.node_paper_coords.add(_delta)),
        _data = {
            position: {
                x: _coords.x,
                y: _coords.y
            }
        };
    this._project.updateElement(this._element, _data, Rkns._SAVE);
    this._renderer.redraw();
}

Rkns.Renderers.Paper__Controllers.Node.prototype.select = function(_delta) {
    this.node_circle.strokeWidth = 3;
}

Rkns.Renderers.Paper__Controllers.Node.prototype.unselect = function(_delta) {
    this.node_circle.strokeWidth = 1;
}

/* */

Rkns.Renderers.Paper__Controllers.Edge = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.Edge.prototype._init = function() {
    this._renderer.edge_layer.activate();
    this.type = "edge";
    this.from_node_controller = this._element.from.__controller;
    this.to_node_controller = this._element.to.__controller;
    this.edge_line = new paper.Path();
    this.edge_line.add([0,0],[0,0]);
    this.edge_line.__controller = this;
    this.edge_arrow = new paper.Path();
    this.edge_arrow.add([0,0],[Rkns._ARROW_LENGTH,Rkns._ARROW_WIDTH / 2],[0,Rkns._ARROW_WIDTH]);
    this.edge_arrow.__controller = this;
    this.edge_text = new paper.PointText();
    this.edge_text.characterStyle = {
        fontSize: Rkns._EDGE_FONT_SIZE,
        fillColor: 'black'
    };
    this.edge_text.paragraphStyle.justification = 'center';
    this.edge_text.__controller = this;
    this.edge_text_angle = 0;
    this.edge_arrow_angle = 0;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.redraw = function() {
    var _p0 = this.from_node_controller.node_paper_coords,
        _p1 = this.to_node_controller.node_paper_coords,
        _a = _p1.subtract(_p0).angle,
        _color = this._element.created_by.color;
    this.edge_paper_coords = _p0.add(_p1).divide(2);
    this.edge_line.strokeColor = _color;
    this.edge_line.segments[0].point = _p0;
    this.edge_line.segments[1].point = _p1;
    this.edge_arrow.rotate(_a - this.edge_arrow_angle);
    this.edge_arrow.fillColor = _color;
    this.edge_arrow.position = this.edge_paper_coords;
    this.edge_arrow_angle = _a;
    if (_a > 90) {
        _a -= 180;
    }
    if (_a < -90) {
        _a += 180;
    }
    this.edge_text.rotate(_a - this.edge_text_angle);
    this.edge_text.content = this._element.title;
    this.edge_text.position = this.edge_paper_coords;
    this.edge_text_angle = _a;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.select = function(_delta) {
    this.edge_line.strokeWidth = 3;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.unselect = function(_delta) {
    this.edge_line.strokeWidth = 1;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.paperShift = function(_delta) {
    this.from_node_controller.paperShift(_delta);
    this.to_node_controller.paperShift(_delta);
    this._renderer.redraw();
}

/* */

Rkns.Renderers.Paper__Controllers.TempEdge = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.TempEdge.prototype._init = function() {
    this._renderer.edge_layer.activate();
    this.type = "temp-edge";
    var _color = this._project.current_user.color;
    this.edge_line = new paper.Path();
    this.edge_line.strokeColor = _color;
    this.edge_line.add([0,0],[0,0]);
    this.edge_line.__controller = this;
    this.edge_arrow = new paper.Path();
    this.edge_arrow.fillColor = _color;
    this.edge_arrow.add([0,0],[Rkns._ARROW_LENGTH,Rkns._ARROW_WIDTH / 2],[0,Rkns._ARROW_WIDTH]);
    this.edge_arrow.__controller = this;
    this.edge_arrow_angle = 0;
}

Rkns.Renderers.Paper__Controllers.TempEdge.prototype.redraw = function() {
    var _p0 = this.from_node_controller.node_paper_coords,
        _p1 = this.end_pos,
        _a = _p1.subtract(_p0).angle,
        _c = _p0.add(_p1).divide(2);
    this.edge_line.segments[0].point = _p0;
    this.edge_line.segments[1].point = _p1;
    this.edge_arrow.rotate(_a - this.edge_arrow_angle);
    this.edge_arrow.position = _c;
    this.edge_arrow_angle = _a;
}

Rkns.Renderers.Paper__Controllers.TempEdge.prototype.paperShift = function(_delta) {
    this.end_pos = this.end_pos.add(_delta);
    this._renderer.onMouseMove({point: this.end_pos});
    this.redraw();
}

Rkns.Renderers.Paper__Controllers.TempEdge.prototype.finishEdge = function(_event) {
    var _hitResult = paper.project.hitTest(_event.point);
    if (_hitResult && typeof _hitResult.item.__controller !== "undefined") {
        var _target = _hitResult.item.__controller;
        if (_target.type === "node" && this.from_node_controller._element.id !== _target._element.id) {
            this._project.addEdge({
                from: this.from_node_controller._element.id,
                to: _target._element.id
            }, Rkns._RENDER_AND_SAVE)
        }
    }
    this._renderer.removeController(this);
}

Rkns.Renderers.Paper__Controllers.TempEdge.prototype.destroy = function() {
    this.edge_arrow.remove();
    this.edge_line.remove();
}

/* */

Rkns.Renderers.Paper__Controllers.NodeEditor = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.NodeEditor.prototype._init = function() {
    this._renderer.overlay_layer.activate();
    this.type = "editor";
    this.editor_block = new paper.Path();
    var _pts = Rkns._(Rkns._.range(8)).map(function() {return [0,0]});
    this.editor_block.add.apply(this.editor_block, _pts);
    this.editor_block.strokeWidth = 2;
    this.editor_block.strokeColor = "#999999";
    this.editor_block.fillColor = "#e0e0e0";
    this.editor_block.opacity = .8;
    this.editor_$ = Rkns.$('<div>')
        .appendTo('.Rk-Editor')
        .css({
            position: "absolute",
            opacity: .8
        })
        .hide();
}

Rkns.Renderers.Paper__Controllers.NodeEditor.prototype.template = Rkns._.template(
    '<h2><span class="Rk-CloseX">&times;</span><%=l10n.edit_node%></span></h2>'
    + '<p><label><%=l10n.edit_title%></label><input class="Rk-Edit-Title" type="text" value="<%=node.title%>"/></p>'
    + '<p><label><%=l10n.edit_uri%></label><input class="Rk-Edit-URI" type="text" value="<%=node.uri%>"/></p>'
    + '<p><label><%=l10n.edit_description%></label><textarea class="Rk-Edit-Description"><%=node.description%></textarea></p>'
    + '<p><label><%=l10n.created_by%></label> <span class="Rk-UserColor" style="background:<%=node.created_by.color%>;"></span> <%=node.created_by.title%></p>'
);

Rkns.Renderers.Paper__Controllers.NodeEditor.prototype.redraw = function() {
    var _coords = this.node_controller.node_paper_coords,
        _element = this.node_controller._element,
        _css = Rkns.Renderers.Paper__Utils.drawEditBox(_coords, this.editor_block, 250, 300);
    this.editor_$
        .html(this.template({
            node: _element,
            l10n: this._project.l10n
        }))
        .show()
        .css(_css);
    var _this = this;
    this.editor_$.find(".Rk-CloseX").click(function() {
        _this._renderer.removeController(_this);
        paper.view.draw();
    });
    this.editor_$.find("input, textarea").bind("keyup change", function() {
        var _data = {
            title: _this.editor_$.find(".Rk-Edit-Title").val(),
            description: _this.editor_$.find(".Rk-Edit-Description").val(),
            uri: _this.editor_$.find(".Rk-Edit-URI").val()
        }
        _this._project.updateElement(
            _element,
            _data,
            Rkns._SAVE
        );
        _this.node_controller.redraw();
        paper.view.draw();
    });
}

Rkns.Renderers.Paper__Controllers.NodeEditor.prototype.destroy = function() {
    this.editor_block.remove();
    this.editor_$.detach();
}


/* */

Rkns.Renderers.Paper__Controllers.EdgeEditor = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.EdgeEditor.prototype._init = function() {
    this._renderer.overlay_layer.activate();
    this.type = "editor";
    this.editor_block = new paper.Path();
    var _pts = Rkns._(Rkns._.range(8)).map(function() {return [0,0]});
    this.editor_block.add.apply(this.editor_block, _pts);
    this.editor_block.strokeWidth = 2;
    this.editor_block.strokeColor = "#999999";
    this.editor_block.fillColor = "#e0e0e0";
    this.editor_block.opacity = .8;
    this.editor_$ = Rkns.$('<div>')
        .appendTo('.Rk-Editor')
        .css({
            position: "absolute",
            opacity: .8
        })
        .hide();
}

Rkns.Renderers.Paper__Controllers.EdgeEditor.prototype.template = Rkns._.template(
    '<h2><span class="Rk-CloseX">&times;</span><%=l10n.edit_edge%></span></h2>'
    + '<p><label><%=l10n.edit_title%></label><input class="Rk-Edit-Title" type="text" value="<%=edge.title%>"/></p>'
    + '<p><label><%=l10n.edit_uri%></label><input class="Rk-Edit-URI" type="text" value="<%=edge.uri%>"/></p>'
    + '<p><label><%=l10n.edit_from%></label><span class="Rk-UserColor" style="background:<%=edge.from.created_by.color%>;"></span><%=edge.from.title%></p>'
    + '<p><label><%=l10n.edit_to%></label><span class="Rk-UserColor" style="background:<%=edge.to.created_by.color%>;"></span><%=edge.to.title%></p>'
    + '<p><label><%=l10n.created_by%> </label><span class="Rk-UserColor" style="background:<%=edge.created_by.color%>;"></span> <%=edge.created_by.title%></p>'
);

Rkns.Renderers.Paper__Controllers.EdgeEditor.prototype.redraw = function() {
    var _coords = this.edge_controller.edge_paper_coords,
        _element = this.edge_controller._element,
        _css = Rkns.Renderers.Paper__Utils.drawEditBox(_coords, this.editor_block, 250, 200);
    this.editor_$
        .html(this.template({
            edge: _element,
            l10n: this._project.l10n
        }))
        .show()
        .css(_css);
    var _this = this;
    this.editor_$.find(".Rk-CloseX").click(function() {
        _this._renderer.removeController(_this);
        paper.view.draw();
    });
    this.editor_$.find("input, textarea").bind("keyup change", function() {
        var _data = {
            title: _this.editor_$.find(".Rk-Edit-Title").val(),
            uri: _this.editor_$.find(".Rk-Edit-URI").val()
        }
        _this._project.updateElement(
            _element,
            _data,
            Rkns._SAVE
        );
        _this.edge_controller.redraw();
        paper.view.draw();
    });
}

Rkns.Renderers.Paper__Controllers.EdgeEditor.prototype.destroy = function() {
    this.editor_block.remove();
    this.editor_$.detach();
}

/* */

Rkns.Renderers.Paper.prototype._init = function() {
    this._MARGIN_X = 80;
    this._MARGIN_Y = 50;
    var _canvas_id = this._project._opts.canvas_id;
    this.$ = Rkns.$("#"+_canvas_id)
    paper.setup(document.getElementById(_canvas_id));
    this.scale = 1;
    this.offset = paper.view.center;
    this.totalScroll = 0;
    this.click_target = null;
    this.selected_target = null;
    this.edge_layer = new paper.Layer();
    this.node_layer = new paper.Layer();
    this.overlay_layer = new paper.Layer();
    var _tool = new paper.Tool(),
        _this = this;
    _tool.minDistance = Rkns._MIN_DRAG_DISTANCE;
    _tool.onMouseMove = function(_event) {
        _this.onMouseMove(_event);
    }
    _tool.onMouseDown = function(_event) {
        _this.onMouseDown(_event);
    }
    _tool.onMouseDrag = function(_event) {
        _this.onMouseDrag(_event);
    }
    _tool.onMouseUp = function(_event) {
        _this.onMouseUp(_event);
    }
    this.$.mousewheel(function(_event, _delta) {
        _this.onScroll(_event, _delta);
    })
    this.$.dblclick(function(_event) {
        _this.onDoubleClick(_event);
    })
    paper.view.onResize = function(_event) {
        _this.offset = _this.offset.add(_event.delta.divide(2));
        _this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.toPaperCoords = function(_point) {
    return _point.multiply(this.scale).add(this.offset);
}


Rkns.Renderers.Paper.prototype.toModelCoords = function(_point) {
    return _point.subtract(this.offset).divide(this.scale);
}

Rkns.Renderers.Paper.prototype.draw = function() {
    var _this = this,
        _xx = this._project.nodes.map(function(_node) { return _node.position.x }),
        _yy = this._project.nodes.map(function(_node) { return _node.position.y }),
        _minx = Math.min.apply(Math, _xx),
        _miny = Math.min.apply(Math, _yy),
        _maxx = Math.max.apply(Math, _xx),
        _maxy = Math.max.apply(Math, _yy);
    this.scale = Math.min((paper.view.size.width - 2 * this._MARGIN_X) / (_maxx - _minx), (paper.view.size.height - 2 * this._MARGIN_Y) / (_maxy - _miny));
    this.offset = paper.view.center.subtract(new paper.Point([(_maxx + _minx) / 2, (_maxy + _miny) / 2]).multiply(this.scale));
    this.controllers = new Rkns.Model.List();
    this._project.nodes.forEach(function(_node) {
        _this.addController("Node", _node);
    });
    this._project.edges.forEach(function(_edge) {
        _this.addController("Edge", _edge);
    });
    
    this.redraw();
}

Rkns.Renderers.Paper.prototype.addController = function(_type, _controller) {
    var _el = new Rkns.Renderers.Paper__Controllers[_type](this, _controller);
    this.controllers.push(_el);
    return _el;
}

Rkns.Renderers.Paper.prototype.removeController = function(_controller) {
    _controller.destroy();
    this.controllers.removeId(_controller);
}

Rkns.Renderers.Paper.prototype.removeControllersOfType = function(_type) {
    var _controllers = this.controllers.filter(function(_ctrl) {
            return _ctrl.type == _type;
        }),
        _this = this;
    _controllers.forEach(function(_ctrl) {
        _this.removeController(_ctrl);
    });
}

Rkns.Renderers.Paper.prototype.redraw = function() {
    this.controllers.forEach(function(_controller) {
        _controller.redraw();
    });
    paper.view.draw();
}

Rkns.Renderers.Paper.prototype.onMouseMove = function(_event) {
    var _hitResult = paper.project.hitTest(_event.point);
    if (_hitResult && typeof _hitResult.item.__controller !== "undefined") {
        if (this.selected_target !== _hitResult.item.__controller) {
            if (this.selected_target) {
                this.selected_target.unselect();
            }
            this.selected_target = _hitResult.item.__controller;
            this.selected_target.select();
        }
    } else {
        if (this.selected_target) {
            this.selected_target.unselect();
        }
        this.selected_target = null;
    }
}

Rkns.Renderers.Paper.prototype.onMouseDown = function(_event) {
    this.is_dragging = false;
    var _hitResult = paper.project.hitTest(_event.point);
    if (_hitResult && typeof _hitResult.item.__controller !== "undefined") {
        this.click_target = _hitResult.item.__controller;
        if (this.click_target.type === "node" && _hitResult.type === "stroke") {
            var _tmpEdge = this.addController("TempEdge",{});
            _tmpEdge.end_pos = _event.point;
            _tmpEdge.from_node_controller = this.click_target;
            _tmpEdge.redraw();
            this.click_target = _tmpEdge;
        }
    } else {
        this.click_target = null;
    }
}

Rkns.Renderers.Paper.prototype.onMouseDrag = function(_event) {
    this.is_dragging = true;
    if (this.click_target && typeof this.click_target.paperShift === "function") {
        this.click_target.paperShift(_event.delta);
    } else {
        this.offset = this.offset.add(_event.delta);
        this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.onMouseUp = function(_event) {
    if (this.click_target) {
        switch (this.click_target.type) {
            case "node":
                if (!this.is_dragging) {
                    this.removeControllersOfType("editor");
                    var _editor = this.addController("NodeEditor",{});
                    _editor.node_controller = this.click_target;
                    _editor.redraw();
                }
            break;
            case "edge":
                if (!this.is_dragging) {
                    this.removeControllersOfType("editor");
                    var _editor = this.addController("EdgeEditor",{});
                    _editor.edge_controller = this.click_target;
                    _editor.redraw();
                }
            break;
            case "temp-edge":
                this.click_target.finishEdge(_event);
            break;
        }
    }
    this.is_dragging = false;
    this.click_target = null;
}

Rkns.Renderers.Paper.prototype.onScroll = function(_event, _scrolldelta) {
    this.totalScroll += _scrolldelta;
    if (Math.abs(this.totalScroll) >= 1) {
        var _off = this.$.offset(),
            _delta = new paper.Point([
                _event.pageX - _off.left,
                _event.pageY - _off.top
            ]).subtract(this.offset).multiply( Math.SQRT2 - 1 );
        if (this.totalScroll > 0) {
            this.offset = this.offset.subtract(_delta);
            this.scale *= Math.SQRT2;
        } else {
            this.offset = this.offset.add(_delta.divide( Math.SQRT2 ));
            this.scale *= Math.SQRT1_2;
        }
        this.totalScroll = 0;
        this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.onDoubleClick = function(_event) {
    var _off = this.$.offset(),
        _point = new paper.Point([
            _event.pageX - _off.left,
            _event.pageY - _off.top
        ]);
    var _hitResult = paper.project.hitTest(_point);
    if (!_hitResult || typeof _hitResult.item.__controller === "undefined") {
        var _coords = this.toModelCoords(_point);
        this._project.addNode({
            position: {
                x: _coords.x,
                y: _coords.y
            }
        }, Rkns._RENDER_AND_SAVE);
    }
    paper.view.draw();
}
