/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.oe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.coweb.oe.ContextVector;
import org.coweb.oe.Operation;
import org.coweb.oe.OperationEngineException;

public class ContextVectorTable {
    private ArrayList<ContextVector> cvt = new ArrayList();

    public ContextVectorTable(ContextVector cv, int site) throws OperationEngineException {
        this.growTo(site + 1);
        this.cvt.set(site, cv);
    }

    public String toString() {
        Object[] arr = new String[this.cvt.size()];
        int l = this.cvt.size();
        for (int i = 0; i < l; ++i) {
            ContextVector cv = this.cvt.get(i);
            arr[i] = cv.toString();
        }
        return Arrays.toString(arr);
    }

    public int[] getEquivalents(ContextVector cv, int skip) {
        ArrayList<Integer> equiv = new ArrayList<Integer>();
        int l = this.cvt.size();
        for (int i = 0; i < l; ++i) {
            if (i == skip || !this.cvt.get(i).equals(cv)) continue;
            equiv.add(new Integer(i));
        }
        int[] ret = new int[equiv.size()];
        int index = 0;
        for (Integer i : equiv) {
            ret[index] = i;
            ++index;
        }
        return ret;
    }

    public int[][] getState() {
        int l = this.cvt.size();
        int[][] arr = new int[l][];
        for (int i = 0; i < l; ++i) {
            ContextVector cv = this.cvt.get(i);
            arr[i] = cv.getState();
        }
        return arr;
    }

    public void setState(int[][] arr) throws OperationEngineException {
        this.cvt = new ArrayList(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("state", arr[i]);
            this.cvt.add(new ContextVector(args));
        }
    }

    public void growTo(int count) throws OperationEngineException {
        int l = this.cvt.size();
        for (int i = 0; i < l; ++i) {
            this.cvt.get(i).growTo(count);
        }
        for (int j = l; j < count; ++j) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("count", count);
            ContextVector cv = new ContextVector(args);
            this.cvt.add(cv);
        }
    }

    public ContextVector getContextVector(int site) throws OperationEngineException {
        if (this.cvt.size() <= site) {
            this.growTo(site + 1);
        }
        return this.cvt.get(site);
    }

    public void updateWithContextVector(int site, ContextVector cv) throws OperationEngineException {
        if (this.cvt.size() <= site) {
            this.growTo(site + 1);
        }
        if (cv.getSize() <= site) {
            cv.growTo(site + 1);
        }
        this.cvt.set(site, cv);
    }

    public void updateWithOperation(Operation op) throws OperationEngineException {
        ContextVector cv = op.getContextVector().copy();
        cv.setSeqForSite(op.siteId, op.seqId);
        this.updateWithContextVector(op.siteId, cv);
    }

    public ContextVector getMinimumContextVector() throws OperationEngineException {
        if (this.cvt == null || this.cvt.size() == 0) {
            return null;
        }
        ContextVector mcv = this.cvt.get(0).copy();
        int l = this.cvt.size();
        for (int i = 1; i < l; ++i) {
            ContextVector cv = this.cvt.get(i);
            for (int site = 0; site < l; ++site) {
                int min;
                int seq = cv.getSeqForSite(site);
                if (seq >= (min = mcv.getSeqForSite(site))) continue;
                mcv.setSeqForSite(site, seq);
            }
        }
        return mcv;
    }
}

