<?php

    require_once("utilsFunctions.php");
    require_once("dbFunctions.php");

    function getRenkan($renkanId) {

        $resRenkan = selectProject($renkanId);

        header('Content-Type: application/json');
        echo($resRenkan[0]['renkan']);
        die();

    }

    function saveRenkan($renkanId, $renkanStr) {

        $renkanJson = json_decode($renkanStr, true);
        if(array_key_exists("title", $renkanJson)) {
            $title = $renkanJson["title"];
        }
        else {
            $title = "";
        }

        $res = updateProject($renkanId, $title, $renkanStr);


        //TODO: return error when fail.
        http_response_code(200);
        echo("RES:");
        print_r($res);
        die();

    }

    function emptyRenkan($title, $description, $renkanId = NULL) {
        if(is_null($renkanId) || trim($renkanId) === '' ) {
            $renkanId = genUuid4();
        }

        $now = new DateTime('NOW');

        $renkan_array = [
            'id' => $renkanId,
            'title' => $title,
            'description' => $description,
            'uri' => NULL,
            'color' => NULL,
            'created' => $now->format("c"),
            'updated' => $now->format("c"),
            'nodes' => [],
            'edges' => [],
            'users' => [],
            'views' => []
        ];

        return json_encode($renkan_array);

    }
