package org.iri_research.renkan.repositories;

import java.io.Serializable;

import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;

import com.mongodb.DBCollection;

public class RenkanRepository<T, ID extends Serializable> extends
        SimpleMongoRepository<T, ID> implements IRenkanRepository<T, ID> {

    public RenkanRepository(MongoEntityInformation<T, ID> metadata,
            MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
    }

    @Override
    public DBCollection getCollection() {
        return this.getMongoOperations().getCollection(
                this.getEntityInformation().getCollectionName());
    }
}
