/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.oe;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.coweb.oe.ContextDifference;
import org.coweb.oe.OperationEngineException;

public class ContextVector {
    private int[] sites;

    public ContextVector(Map<String, Object> args) throws OperationEngineException {
        if (args.containsKey("count")) {
            this.sites = new int[((Integer)args.get("count")).intValue()];
        } else if (args.containsKey("contextVector")) {
            this.sites = ((ContextVector)args.get("contextVector")).copySites();
        } else if (args.containsKey("sites")) {
            int[] s = (int[])args.get("sites");
            this.sites = Arrays.copyOf(s, s.length);
        } else if (args.containsKey("state")) {
            this.sites = (int[])args.get("state");
        } else {
            throw new OperationEngineException("uninitialized context vector");
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(Arrays.toString(this.sites));
        return b.toString();
    }

    public int[] getState() {
        return this.sites;
    }

    public ContextVector copy() throws OperationEngineException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("contextVector", this);
        return new ContextVector(args);
    }

    public int[] copySites() {
        return Arrays.copyOf(this.sites, this.sites.length);
    }

    public ContextDifference subtract(ContextVector cv) {
        ContextDifference cd = new ContextDifference();
        for (int i = 0; i < this.sites.length; ++i) {
            int b;
            int a = this.getSeqForSite(i);
            if (a - (b = cv.getSeqForSite(i)) <= 0) continue;
            cd.addRange(i, b + 1, a + 1);
        }
        return cd;
    }

    public ContextDifference oldestDifference(ContextVector cv) {
        ContextDifference cd = new ContextDifference();
        for (int i = 0; i < this.sites.length; ++i) {
            int b;
            int a = this.getSeqForSite(i);
            if (a - (b = cv.getSeqForSite(i)) <= 0) continue;
            cd.addSiteSeq(i, b + 1);
        }
        return cd;
    }

    public void growTo(int count) {
        int[] newSites = new int[count];
        System.arraycopy(this.sites, 0, newSites, 0, this.sites.length);
        for (int i = this.sites.length; i < count; ++i) {
            newSites[i] = 0;
        }
        this.sites = newSites;
    }

    public int getSeqForSite(int site) {
        if (this.sites.length <= site) {
            this.growTo(site + 1);
        }
        return this.sites[site];
    }

    public void setSeqForSite(int site, int seq) {
        if (this.sites.length <= site) {
            this.growTo(site + 1);
        }
        this.sites[site] = seq;
    }

    public int getSize() {
        return this.sites.length;
    }

    public boolean equals(ContextVector cv) {
        int[] a = this.sites;
        int[] b = cv.sites;
        int max = Math.max(a.length, b.length);
        for (int i = 0; i < max; ++i) {
            int vb;
            int va = i < a.length ? a[i] : 0;
            int n = vb = i < b.length ? b[i] : 0;
            if (va == vb) continue;
            return false;
        }
        return true;
    }

    public int compare(ContextVector cv) {
        int[] a = this.sites;
        int[] b = cv.sites;
        int max = Math.max(a.length, b.length);
        for (int i = 0; i < max; ++i) {
            int vb;
            int va = i < a.length ? a[i] : 0;
            int n = vb = i < b.length ? b[i] : 0;
            if (va < vb) {
                return -1;
            }
            if (va <= vb) continue;
            return 1;
        }
        return 0;
    }

    public int[] getSites() {
        return this.sites;
    }
}

