Rkns.defaults = {
	
    language: (navigator.language || navigator.userLanguage || "en"),
    	/* GUI Language */
    container: "renkan",
    	/* GUI Container DOM element ID */
    search: [],
    	/* List of Search Engines */
   	bins: [],
   		/* List of Bins */
	static_url: "",
		/* URL for static resources */
	show_bins: true,
		/* Show bins in left column */
	properties: [],
		/* Semantic properties for edges */
	read_only: false,
		/* Allows editing of renkan without changing the rest of the GUI. Can be switched on/off on the fly to block/enable editing */
	editor_mode: true,
		/* Switch for Publish/Edit GUI. If editor_mode is false, read_only will be true.  */
    snapshot_mode: false,
    	/* In snapshot mode, clicking on the floppy will save a snapshot. Otherwise, it will show the connection status */
	show_top_bar: true,
		/* Show the top bar, (title, buttons, users) */
	default_user_color: "#303030",
	
	/* MINI-MAP OPTIONS */
	
    show_minimap: true,
    	/* Show a small map at the bottom right */
    minimap_width: 160,
    minimap_height: 120,
    minimap_background_color: "#ffffff",
    minimap_border_color: "#cccccc",
    minimap_highlight_color: "#ffff00",
    minimap_highlight_weight: 5,
    
    /* EDGE/NODE COMMON OPTIONS */
   	
   	buttons_background: "#202020",
   	buttons_label_color: "#c000c0",
   	buttons_label_font_size: 9,
	
	/* NODE DISPLAY OPTIONS */
	
    show_node_circles: true,
    	/* Show circles for nodes */
	clip_node_images: true,
		/* Constraint node images to circles */
	node_size_base: 25,
	node_stroke_width: 2,
	selected_node_stroke_width: 4,
	node_fill_color: "#ffffff",
	highlighted_node_fill_color: "#ffff00",
	node_label_color: "#000000",
	node_label_font_size: 10,
	node_label_font: 'Helvetica, Arial, sans-serif',
	node_label_distance: 5,
		/* Vertical distance between node and label */
	node_label_max_length: 40,
		/* Maximum displayed text length */
	
	/* EDGE DISPLAY OPTIONS */
	
	edge_stroke_width: 2,
	selected_edge_stroke_width: 4,
	edge_label_color: "#000000",
	edge_label_font_size: 9,
	edge_label_font: 'Helvetica, Arial, sans-serif',
	edge_label_distance: -3,
	edge_label_max_length: 20,
    edge_arrow_length: 18,
    edge_arrow_width: 12,
    edge_gap_in_bundles: 12,
    
    /* CONTEXTUAL DISPLAY (TOOLTIP OR EDITOR) OPTIONS */
   
   	tooltip_width: 275,
   	tooltip_padding: 10,
   	tooltip_margin: 15,
    tooltip_arrow_length : 20,
    tooltip_arrow_width : 40,
   	tooltip_top_color: "#f0f0f0",
   	tooltip_bottom_color: "#d0d0d0",
   	tooltip_border_color: "#808080",
   	tooltip_border_width: 1
	
}
