# -*- coding: utf-8 -*-
import json,os

from django.test import TestCase
from renkanmanager.models import content_copy
from django.contrib.auth import get_user_model

User = get_user_model()

class ModelsTest(TestCase):

    def setUp(self):
        test_json_path = os.path.join(os.path.dirname(__file__), 'test_revision_copy.json')
        with open(test_json_path) as json_file:
            self.test_json = json_file.read()

    def test_content_copy_call(self):
        c_copy = content_copy(self.test_json)
        self.assertIsNotNone(c_copy)

    def test_content_copy_id_key(self):
        c_copy = content_copy(self.test_json)
        self.assertIn('id', c_copy)
        self.assertNotIn('_id', c_copy)
        for n in c_copy['nodes']:
            self.assertIn('id', n)
            self.assertNotIn('_id', n)
        for u in c_copy['users']:
            self.assertIn('id', u)
            self.assertNotIn('_id', u)
        for v in c_copy['views']:
            self.assertIn('id', v)
            self.assertNotIn('_id', v)
        for e in c_copy['edges']:
            self.assertIn('id', e)
            self.assertNotIn('_id', e)

    def test_content_copy_content(self):
        c_copy = content_copy(self.test_json)
        c_json = json.loads(self.test_json)

        for k in (c_copy.keys() - ['nodes', 'users', 'views', 'edges', 'id']):
            self.assertEquals(c_copy[k], c_json[k])

        self.assertEquals(len(c_copy['nodes']), len(c_json['nodes']))
        for node in c_copy['nodes']:
            original_nodes = [ n for n in c_json['nodes'] if n['title'] == node['title'] ]
            self.assertEquals(1,len(original_nodes))
            for k in (node.keys() - ['id']):
                self.assertEquals(node[k], original_nodes[0][k])

        self.assertEquals(len(c_copy['edges']), len(c_json['edges']))
        for edge in c_copy['edges']:
            original_edges = [ e for e in c_json['edges'] if e['title'] == edge['title'] ]
            self.assertEquals(1,len(original_edges))
            orig_edge = original_edges[0]
            for k in (edge.keys() - ['id', 'from', 'to']):
                self.assertEquals(edge[k], orig_edge[k])
            from_copy = [e for e in c_copy['nodes'] if e['id'] == edge['from']][0]
            from_orig = [e for e in c_json['nodes'] if e['_id'] == orig_edge['from']][0]
            self.assertEquals(from_copy['title'], from_orig['title'])

            to_copy = [e for e in c_copy['nodes'] if e['id'] == edge['to']][0]
            to_orig = [e for e in c_json['nodes'] if e['_id'] == orig_edge['to']][0]
            self.assertEquals(to_copy['title'], to_orig['title'])

        self.assertEquals(len(c_copy['users']), len(c_json['users']))
        for user in c_copy['users']:
            original_users = [ u for u in c_json['users'] if u['title'] == user['title'] ]
            self.assertEquals(1,len(original_users))
            for k in (user.keys() - ['id']):
                self.assertEquals(user[k], original_users[0][k])

        self.assertEquals(len(c_copy['views']), len(c_json['views']))
        for view in c_copy['views']:
            original_views = [ v for v in c_json['views'] if v['title'] == view['title'] ]
            self.assertEquals(1,len(original_views))
            orig_view = original_views[0]
            for k in (view.keys() - ['id', 'hidden_nodes']):
                self.assertEquals(view[k], orig_view[k])
            self.assertEquals(len(view['hidden_nodes']), len(orig_view['hidden_nodes']))
            copy_hidden_nodes_titles = sorted([ [n for n in c_copy['nodes'] if n['id'] == n_id][0]['title'] for n_id in view['hidden_nodes']])
            orig_hidden_nodes_titles = sorted([ [n for n in c_json['nodes'] if n['_id'] == n_id][0]['title'] for n_id in orig_view['hidden_nodes']])

            self.assertEquals(copy_hidden_nodes_titles, orig_hidden_nodes_titles)
