/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.oe;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import org.coweb.oe.ContextDifference;
import org.coweb.oe.Operation;
import org.coweb.oe.OperationEngineException;

public class HistoryBuffer {
    private static final Logger log = Logger.getLogger(HistoryBuffer.class.getName());
    private HashMap<String, Operation> ops = new HashMap();
    private int size = 0;

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{ops : " + this.ops);
        b.append(",size : " + this.size);
        b.append("}");
        return b.toString();
    }

    public Object[] getState() {
        Vector<Object[]> v = new Vector<Object[]>();
        Operation op = null;
        for (String key : this.ops.keySet()) {
            op = this.ops.get(key);
            v.addElement(op.getState());
        }
        return v.toArray();
    }

    public void setState(Object[] arr) {
        this.size = 0;
        this.ops.clear();
        for (int i = 0; i < arr.length; ++i) {
            Operation op = null;
            try {
                op = Operation.createOperationFromState((Object[])arr[i]);
                this.addLocal(op);
                continue;
            }
            catch (OperationEngineException e) {
                // empty catch block
            }
        }
    }

    public Stack<Operation> getOpsForDifference(ContextDifference cd) throws OperationEngineException {
        String[] keys = cd.getHistoryBufferKeys();
        Vector<Operation> opsStack = new Vector<Operation>();
        int l = keys.length;
        for (int i = 0; i < l; ++i) {
            log.info("key = " + keys[i]);
            String key = keys[i];
            Operation op = this.ops.get(key);
            if (op == null) {
                throw new OperationEngineException("missing op for context diff: i=" + i + " key=" + key + " keys=" + keys.toString());
            }
            opsStack.addElement(op);
        }
        Operation[] arr = new Operation[opsStack.size()];
        arr = opsStack.toArray(arr);
        Arrays.sort(arr, new Comparator<Operation>(){

            @Override
            public int compare(Operation a, Operation b) {
                return a.compareByOrder(b);
            }
        });
        Stack<Operation> stack = new Stack<Operation>();
        stack.addAll(Arrays.asList(arr));
        return stack;
    }

    public void addLocal(Operation op) {
        String key = Operation.createHistoryKey(op.siteId, op.seqId);
        this.ops.put(key, op);
        op.immutable = true;
        ++this.size;
    }

    public void addRemote(Operation op) throws OperationEngineException {
        String key = Operation.createHistoryKey(op.siteId, op.seqId);
        Operation eop = this.ops.get(key);
        if (op.order == 99999999) {
            throw new OperationEngineException("remote op missing total order");
        }
        if (eop != null) {
            if (eop.order != 99999999) {
                throw new OperationEngineException("duplicate op in total order: old=" + eop.order + " new=" + op.order);
            }
            eop.order = op.order;
        } else {
            this.ops.put(key, op);
            op.immutable = true;
            ++this.size;
        }
    }

    public Operation remove(Operation op) {
        String key = Operation.createHistoryKey(op.siteId, op.seqId);
        op = this.ops.remove(key);
        op.immutable = false;
        --this.size;
        return op;
    }

    public int getCount() {
        return this.size;
    }

    public Stack<Operation> getContextSortedOperations() {
        Collection<Operation> collection = this.ops.values();
        Operation[] arr = new Operation[collection.size()];
        arr = collection.toArray(arr);
        Arrays.sort(arr, new Comparator<Operation>(){

            @Override
            public int compare(Operation a, Operation b) {
                return a.compareByContext(b);
            }
        });
        Stack<Operation> stack = new Stack<Operation>();
        stack.addAll(Arrays.asList(arr));
        return stack;
    }
}

