import os
import django.conf.global_settings as defaults

DEBUG = True
USE_TZ = True

ROOT_URLCONF = 'renkanmanager.urls'
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'APP_DIRS': True,
    },
]

MIGRATION_MODULES = {"renkanmanager": None}

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
        },
    },
    'loggers': {
        'django': {
            'handlers': ['console'],
            'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
        },
        'renkanmanager': {
            'handlers': ['console'],
            'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
        },
    },
}

SECRET_KEY = "1Xks0ybXuEVZI32HbgGKje9L97ezev5vJJIohGB5aLo9rUi1BV"

MIDDLEWARE_CLASSES = defaults.MIDDLEWARE_CLASSES + [
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
]

INSTALLED_APPS = (
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.auth',
    'easy_thumbnails',
    'renkanmanager'
)

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3'
    }
}

AUTH_USER_MODEL='auth.User'
