/**
 * 
 */
package org.iri_research.renkan.db;

import java.net.UnknownHostException;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;

/**
 * This singleton class manage the mongo connection.
 * This class is thread safe
 * The singleton class is implemented following this example : http://en.wikipedia.org/wiki/Singleton_pattern#The_solution_of_Bill_Pugh
 * @author ymh
 *
 */
public class MongoConnectionManager {

	//TODO: add application parameters
	public static final String HOST = "127.0.0.1";
	public static final int PORT = 27017;
	public static final String NAME = "renkan";
	
	private Mongo mongo = null;
	private DB db = null;
	
	public DB getDb() throws UnknownHostException, MongoException {
		if(null == this.db) {
			this.mongo = new Mongo(HOST, PORT);
			this.db = this.mongo.getDB(NAME);
		}
		return db;
	}

	// Private constructor suppresses generation
	//  of a (public) default constructor
	private MongoConnectionManager() {}
	
	private static class SingletonHolder {
		public static final MongoConnectionManager INSTANCE = new MongoConnectionManager();
	}
	
	public static MongoConnectionManager getInstance() {
		return SingletonHolder.INSTANCE;
	}
	
	
	
}
