Rkns.Twitter = {
}

Rkns.Twitter.Search = function(_renkan, _opts) {
	this.renkan = _renkan;
	this.opts = _opts;
}

Rkns.Twitter.Search.prototype.getBgClass = function() {
	return "Rk-Twitter-Icon";
}

Rkns.Twitter.Search.prototype.getSearchTitle = function() {
	return this.renkan.translate("Twitter");
}

Rkns.Twitter.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.Twitter.Bin(this.renkan, {
            search: _q
        })
    );
}

Rkns.Twitter.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.Twitter.Bin.prototype.tweetTemplate = Rkns._.template(
    '<li class="Rk-Twitter-Tweet Rk-Bin-Item" data-uri="http://twitter.com/<%=tweet.from_user%>/status/<%=tweet.id_str%>" '
    + 'data-title="Tweet by @<%=tweet.from_user%>" data-description="<%-tweet.text%>" data-image="<%=tweet.profile_image_url%>">'
    + '<img class="Rk-Twitter-TwImage" src="<%=tweet.profile_image_url%>" />'
    + '<h4 class="Rk-Twitter-TwTitle"><a href="http://twitter.com/<%=tweet.from_user%>" target="_blank">@<%=tweet.from_user%></a> (<%=tweet.from_user_name%>)</h4>'
    + '<p class="Rk-Twitter-TwDate"><%=date%></p>'
    + '<p class="Rk-Twitter-TwText"><%=text%></p>'
    + '<p class="Rk-Twitter-TwActions"><a class="Rk-Twitter-TwAction" href="http://twitter.com/<%=tweet.from_user%>/status/<%=tweet.id_str%>" target="_blank">show original</a> · '
    + '<a href="http://twitter.com/intent/tweet?in_reply_to=<%=tweet.id_str%>" target="_blank">reply</a> · '
    + '<a href="http://twitter.com/intent/retweet?tweet_id=<%=tweet.id_str%>" target="_blank">retweet</a> · '
    + '<a href="http://twitter.com/intent/favorite?tweet_id=<%=tweet.id_str%>" target="_blank">favorite</a></p></li>'
);

Rkns.Twitter.Bin.prototype._init = function(_renkan, _opts) {
	this.renkan = _renkan;
    this.search = _opts.search;
    this.title_icon_$.addClass('Rk-Twitter-Title-Icon');
    this.title_$.html(this.search).addClass("Rk-Twitter-Title");
    this.refresh();
}

Rkns.Twitter.Bin.prototype.render = function(searchstr) {
    var _rgxp = new RegExp('('+(searchstr || this.search).replace(/(\W)/g,'\\$1')+')','gi');
    if (searchstr) {
        var rxtest = new RegExp(searchstr.replace(/(\W)/g,'\\$1'),'i');
    }
    function highlight(_text) {
        return _text.replace(_rgxp, "<span class='searchmatch'>$1</span>");
    }
    var _html = ""
        _this = this,
        count = 0;
    Rkns._(this.data.results).each(function(_result) {
        if (searchstr && !rxtest.test(_result.text)) {
            return;
        }
        count++;
        var _entities = [],
            _users = _result.text.match(/@[\w_]+/gm),
            _lastpos = 0;
        if (_users) {
            for (var _i = 0; _i < _users.length; _i++) {
                var _m = _users[_i],
                    _start = _lastpos + _result.text.substr(_lastpos).search(_m),
                    _lastpos = _start + _m.length;
                _entities.push({
                    "text" : _m,
                    "start" : _start,
                    "end" : _lastpos,
                    "link" :'<a href="http://twitter.com/' + _m.substr(1) + '" onclick="filtrerTexte(\'' + _m + '\'); return false;" target="_blank">',
                });
            }
        }
        var _hashes = _result.text.match(/([^&]|^)#[^\s,.!?=#@&;()]+/gm),
            _lastpos = 0;
        if (_hashes) {
            for (var _i = 0; _i < _hashes.length; _i++) {
                var _m = _hashes[_i],
                    _h = ( _m[0] == '#' ? _m : _m.substr(1) ),
                    _start = _lastpos + _result.text.substr(_lastpos).search(_h),
                    _lastpos = _start + _h.length;
                _entities.push({
                    "text" : _h,
                    "start" : _start,
                    "end" : _lastpos,
                    "link" :'<a href="http://twitter.com/search?q=' + encodeURIComponent(_h) + '" onclick="filtrerTexte(\'' + _.escape(_h) + '\'); return false;" target="_blank">',
                });
            }
        }
        
        var _urls = _result.text.match(/(www\.|https?:\/\/)[\w./_\-]+/gim),
            _lastpos = 0;
        if (_urls) {
            for (var _i = 0; _i < _urls.length; _i++) {
                var _m = _urls[_i],
                    _start = _lastpos + _result.text.substr(_lastpos).search(_m),
                    _lastpos = _start + _m.length;
                _entities.push({
                    "text" : _m,
                    "start" : _start,
                    "end" : _lastpos,
                    "link" :'<a href="' + _m + '" target="_blank">',
                });
            }
        }
        _entities = Rkns._(_entities).sortBy(function(a) { return a.start });
        var _lastend = 0,
            _text = Rkns._(_entities).map(function(_e) {
                var _txt = highlight(_result.text.substring(_lastend, _e.start)) + _e.link + highlight(_e.text) + '</a>';
                _lastend = _e.end;
                return _txt;
            }).join("") + highlight(_result.text.substring(_lastend));
        
        _html += _this.tweetTemplate({
            tweet: _result,
            date: new Date(_result.created_at.replace(/(\+|-)/,'UTC$1')).toLocaleString(),
            text: _text
        });
    });
    this.main_$.html(_html);
    if (searchstr && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (searchstr && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
}

Rkns.Twitter.Bin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: "http://search.twitter.com/search.json",
        dataType: "jsonp",
        data: {
            q: this.search,
            rpp: 100
        },
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
}
