package org.iri_research.renkan.repositories;

import java.util.List;

import org.iri_research.renkan.models.Project;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.Query;

public interface ProjectsRepository extends IRenkanRepository<Project, String>,
        ProjectsRepositoryCustom {

    List<Project> findBySpaceId(String spaceId);

    Page<Project> findBySpaceId(String spaceId, Pageable p);

    @Query("{ 'space_id' : ?0, 'title' : { '$regex':?1, '$options': 'i'} }")
    List<Project> findBySpaceIdAndTitleRegex(String spaceId, String title);

    @Query("{ 'space_id' : ?0, 'title' : { '$regex':?1, '$options': 'i'} }")
    Page<Project> findBySpaceIdAndTitleRegex(String spaceId, String title,
            Pageable p);
}
