"""renkan URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.8/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Add an import:  from blog import urls as blog_urls
    2. Add a URL to urlpatterns:  url(r'^blog/', include(blog_urls))
"""
from django.conf.urls import include, url
from django.contrib import admin
from renkanmanager.api.views import RenkanList, RenkanDetail, WorkspaceList, WorkspaceDetail, RevisionList, RevisionDetail

urlpatterns = [
    url(r'^api/renkans/$', RenkanList.as_view(), name='renkan_list'),
    url(r'^api/workspaces/(?P<workspace_guid>[\w-]+)/renkans/$', RenkanList.as_view(), name='renkan_list_workspace'),
    url(r'^api/renkans/(?P<renkan_guid>[\w-]+)/$', RenkanDetail.as_view(), name='renkan_detail'),
    url(r'^api/workspaces/$', WorkspaceList.as_view(), name='workspace_list'),
    url(r'^api/workspaces/(?P<workspace_guid>[\w-]+)/$', WorkspaceDetail.as_view(), name='workspace_detail'),
    url(r'^api/renkans/(?P<renkan_guid>[\w-]+)/revisions/$', RevisionList.as_view(), name='revision_list'),
    url(r'^api/renkans/(?P<renkan_guid>[\w-]+)/revisions/(?P<revision_guid>[\w-]+)/$', RevisionDetail.as_view(), name='revision_detail')
]
