package org.iri_research.renkan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Constants {
	
	@SuppressWarnings("serial")
	public final static List<String> VERSION = Collections.unmodifiableList(new ArrayList<String>() {
		{
			add("0");
			add("1");
			add("0");
			add("final");
			add("0");
		}
	});
	
	
	public static String getVersion() {
		
		String[] version_array = VERSION.toArray(new String[VERSION.size()]);
		
	    String version = String.format("%s.%s",version_array[0], version_array[1]);
	    if(version_array[2] != null && !version_array[2].isEmpty() &&  Integer.parseInt(version_array[2]) > 0 ) {
	    	version = String.format("%s.%s", version, version_array[2]);
	    }
	    if (version_array[3] == "alpha" && version_array[4] == "0") {
	    	version = String.format("%s pre-alpha",version);
	    }
	    else if(version_array[3] != "final") {
	        version = String.format("%s %s %s", version, version_array[3], version_array[4]);
	    }
	    return version;

	}

}
