# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings
import uuid

def populate_revision(apps, schema_editor):
    renkans = apps.get_model('renkanmanager', 'Renkan')
    revisions = apps.get_model('renkanmanager', 'Revision')
    for renkan in renkans.objects.all():
        renkan.creator = renkan.owner
        renkan.renkan_guid = renkan.rk_id
        if not renkan.current_revision_guid:
            new_revision = revisions.objects.create()
            new_revision.parent_renkan_guid = renkan.renkan_guid
            new_revision.creator = renkan.creator
            new_revision.last_updated_by = renkan.creator
            new_revision.title = renkan.title
            new_revision.content = renkan.content
            new_revision.creation_date = renkan.creation_date
            new_revision.modification_date = renkan.modification_date
            new_revision.save()
            renkan.current_revision_guid = new_revision.revision_guid
        renkan.save()

class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('renkanmanager', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Revision',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('revision_guid', models.CharField(default=uuid.uuid4, unique=True, max_length=256)),
                ('parent_renkan_guid', models.CharField(max_length=256)),
                ('title', models.CharField(max_length=1024, null=True, blank=True)),
                ('content', models.TextField(null=True, blank=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('modification_date', models.DateTimeField(auto_now=True)),
                ('creator', models.ForeignKey(related_name='revision_creator', blank=True, to=settings.AUTH_USER_MODEL, null=True)),
                ('last_updated_by', models.ForeignKey(related_name='revision_last_updated_by', blank=True, to=settings.AUTH_USER_MODEL, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Workspace',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('workspace_guid', models.CharField(default=uuid.uuid4, unique=True, max_length=1024)),
                ('title', models.CharField(max_length=1024, null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('creator', models.ForeignKey(related_name='workspace_creator', blank=True, to=settings.AUTH_USER_MODEL, null=True)),
            ],
        ),
        migrations.AddField(
            model_name='renkan',
            name='creator',
            field=models.ForeignKey(related_name='renkan_creator', blank=True, to=settings.AUTH_USER_MODEL, null=True),
        ),
        migrations.AddField(
            model_name='renkan',
            name='current_revision_guid',
            field=models.CharField(max_length=256, null=True, blank=True),
        ),
        migrations.AddField(
            model_name='renkan',
            name='renkan_guid',
            field=models.CharField(default=uuid.uuid4, unique=True, max_length=256),
        ),
        migrations.AddField(
            model_name='renkan',
            name='source_revision_guid',
            field=models.CharField(max_length=256, null=True, blank=True),
        ),
        migrations.AddField(
            model_name='renkan',
            name='workspace_guid',
            field=models.CharField(max_length=256, null=True, blank=True),
        ),
        migrations.AddField(
            model_name='renkan',
            name='state',
            field=models.IntegerField(default=1),
        ),
        migrations.RunPython(populate_revision),
        migrations.RemoveField(
            model_name='renkan',
            name='content',
        ),
        migrations.RemoveField(
            model_name='renkan',
            name='image',
        ),
        migrations.RemoveField(
            model_name='renkan',
            name='modification_date',
        ),
        migrations.RemoveField(
            model_name='renkan',
            name='owner',
        ),
        migrations.RemoveField(
            model_name='renkan',
            name='rk_id',
        ),
        migrations.RemoveField(
            model_name='renkan',
            name='title',
        ),
    ]
