/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.oe;

import java.util.HashMap;
import java.util.Stack;
import org.coweb.oe.ContextDifference;
import org.coweb.oe.ContextVector;
import org.coweb.oe.ContextVectorTable;
import org.coweb.oe.HistoryBuffer;
import org.coweb.oe.Operation;
import org.coweb.oe.OperationEngineException;

public class OperationEngine {
    private int siteId;
    private ContextVector cv = null;
    private ContextVectorTable cvt = null;
    private HistoryBuffer hb = null;
    private int siteCount = 1;

    public OperationEngine(int siteId) throws OperationEngineException {
        this.siteId = siteId;
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("count", siteId + 1);
        this.cv = new ContextVector(args);
        this.cvt = new ContextVectorTable(this.cv, siteId);
        this.hb = new HistoryBuffer();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{siteId : " + this.siteId);
        b.append(",ContextVector : " + this.cv);
        b.append(",ContextVectorTable : " + this.cvt);
        b.append(",HistoryBuffer : " + this.hb);
        b.append(",siteCount : " + this.siteCount);
        b.append("}");
        return b.toString();
    }

    public Object[] getState() {
        int[] frozen = this.cvt.getEquivalents(this.cv, this.siteId);
        Object[] ret = new Object[]{this.cvt.getState(), this.hb.getState(), new Integer(this.siteId), frozen};
        return ret;
    }

    public void setState(Object[] arr) throws OperationEngineException {
        this.cvt.setState((int[][])arr[0]);
        this.hb.setState((Object[])arr[1]);
        this.cv = this.cvt.getContextVector((Integer)arr[2]);
        this.cv = this.cv.copy();
        this.cvt.updateWithContextVector(this.siteId, this.cv);
        this.siteCount = this.cv.getSize();
        int[] frozen = (int[])arr[3];
        for (int i = 0; i < frozen.length; ++i) {
            this.freezeSite(frozen[i]);
        }
    }

    public ContextVector copyContextVector() throws OperationEngineException {
        return this.cv.copy();
    }

    public Operation createOp(boolean local, String key, String value, String type, int position, int site, int[] cv, int order) throws OperationEngineException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (local) {
            args.put("key", key);
            args.put("position", new Integer(position));
            args.put("value", value);
            args.put("siteId", new Integer(this.siteId));
            args.put("contextVector", this.copyContextVector());
            args.put("local", true);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sites", cv);
            ContextVector contextVector = new ContextVector(map);
            args.put("key", key);
            args.put("position", new Integer(position));
            args.put("value", value);
            args.put("siteId", new Integer(site));
            args.put("contextVector", contextVector);
            args.put("order", order);
            args.put("local", false);
        }
        return Operation.createOperationFromType(type, args);
    }

    public Operation push(boolean local, String key, String value, String type, int position, int site, int[] cv, int order) throws OperationEngineException {
        Operation op = this.createOp(local, key, value, type, position, site, cv, order);
        if (local) {
            return this.pushLocalOp(op);
        }
        return this.pushRemoteOp(op);
    }

    public Operation pushLocalOp(Operation op) {
        this.cv.setSeqForSite(op.getSiteId(), op.getSeqId());
        this.hb.addLocal(op);
        return op;
    }

    public Operation pushRemoteOp(Operation op) throws OperationEngineException {
        Operation top = null;
        if (this.hasProcessedOp(op)) {
            this.hb.addRemote(op);
            return null;
        }
        if (this.cv.equals(op.getContextVector())) {
            top = op.copy();
        } else {
            ContextDifference cd = this.cv.subtract(op.getContextVector());
            op.setImmutable(true);
            top = this._transform(op, cd);
        }
        this.cv.setSeqForSite(op.getSiteId(), op.getSeqId());
        this.hb.addRemote(op);
        this.cvt.updateWithOperation(op);
        return top;
    }

    public void pushSync(int site, ContextVector cv) throws OperationEngineException {
        this.cvt.updateWithContextVector(site, cv);
    }

    public void pushSyncWithSites(int site, int[] sites) throws OperationEngineException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("sites", sites);
        ContextVector cv = new ContextVector(args);
        this.pushSync(site, cv);
    }

    public ContextVector purge() throws OperationEngineException {
        if (this.getBufferSize() == 0) {
            return null;
        }
        ContextVector mcv = this.cvt.getMinimumContextVector();
        if (mcv == null) {
            return null;
        }
        Operation min_op = null;
        ContextDifference cd = this.cv.oldestDifference(mcv);
        Stack<Operation> ops = this.hb.getOpsForDifference(cd);
        while (ops.size() > 0) {
            Operation curr = ops.pop();
            if (min_op != null && curr.compareByContext(min_op) != -1) continue;
            cd = this.cv.oldestDifference(curr.getContextVector());
            ops.addAll(this.hb.getOpsForDifference(cd));
            min_op = curr;
        }
        ops = this.hb.getContextSortedOperations();
        for (int i = 0; i < ops.size(); ++i) {
            Operation op = (Operation)ops.elementAt(i);
            if (min_op != null && min_op.getSiteId() == op.getSiteId() && min_op.getSeqId() == op.getSeqId()) break;
            this.hb.remove(op);
        }
        return mcv;
    }

    public int getBufferSize() {
        return this.hb.getCount();
    }

    public boolean hasProcessedOp(Operation op) {
        int seqId = this.cv.getSeqForSite(op.getSiteId());
        return seqId >= op.getSeqId();
    }

    public void freezeSite(int site) throws OperationEngineException {
        if (this.cvt.getContextVector(site) != this.cv) {
            this.cvt.updateWithContextVector(site, this.cv);
            --this.siteCount;
        }
    }

    public void thawSite(int site) throws OperationEngineException {
        if (site == this.siteId) {
            return;
        }
        ContextVector cv = this.cvt.getMinimumContextVector();
        cv.growTo(site);
        this.cvt.updateWithContextVector(site, cv);
        ++this.siteCount;
    }

    public int getSiteCount() {
        return this.siteCount;
    }

    private Operation _transform(Operation op, ContextDifference cd) throws OperationEngineException {
        Stack<Operation> ops = this.hb.getOpsForDifference(cd);
        Operation xop = null;
        ContextDifference xcd = null;
        Operation cxop = null;
        Operation cop = null;
        op = op.copy();
        for (int i = 0; i < ops.size(); ++i) {
            xop = (Operation)ops.elementAt(i);
            if (!op.getContextVector().equals(xop.getContextVector())) {
                cxop = xop.getFromCache(op.getContextVector());
                if (cxop != null) {
                    xop = cxop;
                } else {
                    xcd = op.getContextVector().subtract(xop.getContextVector());
                    if (xcd.sites == null || xcd.sites.size() == 0) {
                        throw new OperationEngineException("transform produced empty context diff");
                    }
                    cxop = this._transform(xop, xcd);
                    if (cxop == null) {
                        op.upgradeContextTo(xop);
                        continue;
                    }
                    xop = cxop;
                }
            }
            if (!op.getContextVector().equals(xop.getContextVector())) {
                throw new OperationEngineException("context vectors unequal after upgrade");
            }
            cop = op.copy();
            if ((op = op.transformWith(xop)) == null) {
                return null;
            }
            op.addToCache(this.siteCount);
            xop = xop.copy();
            xop = xop.transformWith(cop);
            if (xop == null) continue;
            xop.addToCache(this.siteCount);
        }
        return op;
    }

    public int getSiteId() {
        return this.siteId;
    }
}

