
define(['jquery', 'underscore', 'requtils', 'renderer/basebutton'], function ($, _, requtils, BaseButton) {
    'use strict';
    
    var Utils = requtils.getUtils();

    /* _NodeButton Begin */

    //var _NodeButton = Renderer._NodeButton = Utils.inherit(Renderer._BaseButton);
    var _NodeButton = Utils.inherit(BaseButton);

    _(_NodeButton.prototype).extend({
        setSectorSize: function() {
            var sectorInner = this.source_representation.circle_radius;
            if (sectorInner !== this.lastSectorInner) {
                if (this.sector) {
                    this.sector.destroy();
                }
                this.sector = this.renderer.drawSector(
                        this, 1 + sectorInner,
                        Utils._NODE_BUTTON_WIDTH + sectorInner,
                        this.startAngle,
                        this.endAngle,
                        1,
                        this.imageName,
                        this.renkan.translate(this.text)
                );
                this.lastSectorInner = sectorInner;
            }
        }
    });

    /* _NodeButton End */

    return _NodeButton;

});
