package org.iri_research.renkan.models;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import com.fasterxml.jackson.annotation.JsonProperty;

@Document(collection="nodes")
public class Node extends AbstractRenkanModel<String> {

	public Node(Node node, String projectId) {
		this(UUID.randomUUID().toString(), node.title, node.description, node.uri, node.color, node.createdBy, node.position, node.image, node.size, projectId);
	}
	
	public Node(Node node) {
		this(node, node.projectId);
	}
	
	@SuppressWarnings("unused")
	private Node() {		
	}

	@Autowired(required=true)
	public Node(String id, String title, String description, String uri, String color, String createdBy, Point position, String image, Integer size, String projectId) {
		super(id, title, description, uri, color);
		
		this.projectId = projectId;
		this.createdBy = createdBy;
		this.position = position;
		this.image = image;
		this.size = (size == null) ? 0 : size.intValue();
	}	

	@Field("project_id")
	@JsonProperty("project_id")	
	private String projectId = null;	

	@Field("created_by")
	@JsonProperty("created_by")
	private String createdBy = null;
	
	private Point position = null;

	private String image;
	
	private int size;
	
	public Point getPosition() {
		return position;
	}

	public String getImage() {
		return image;
	}

	@JsonProperty("project_id")
	public String getProjectId() {
		return projectId;
	}

	@JsonProperty("created_by")
	public String getCreatedBy() {
		return createdBy;
	}

	public int getSize() {
		return size;
	}
	
}
