"use strict";

define(['jquery', 'underscore', 'requtils', 'renderer/baseeditor'], function ($, _, requtils, BaseEditor) {
    
    var Utils = requtils.getUtils();

    /* EdgeEditor Begin */

    //var EdgeEditor = Renderer.EdgeEditor = Utils.inherit(Renderer._BaseEditor);
    var EdgeEditor = Utils.inherit(BaseEditor);

    _(EdgeEditor.prototype).extend({
        template: _.template(
                '<h2><span class="Rk-CloseX">&times;</span><%-renkan.translate("Edit Edge")%></span></h2>'
                + '<p><label><%-renkan.translate("Title:")%></label><input class="Rk-Edit-Title" type="text" value="<%-edge.title%>"/></p>'
                + '<% if (options.show_edge_editor_uri) { %><p><label><%-renkan.translate("URI:")%></label><input class="Rk-Edit-URI" type="text" value="<%-edge.uri%>"/><a class="Rk-Edit-Goto" href="<%-edge.uri%>" target="_blank"></a></p>'
                + '<% if (options.properties.length) { %><p><label><%-renkan.translate("Choose from vocabulary:")%></label><select class="Rk-Edit-Vocabulary">'
                + '<% _(options.properties).each(function(ontology) { %><option class="Rk-Edit-Vocabulary-Class" value=""><%- renkan.translate(ontology.label) %></option>'
                + '<% _(ontology.properties).each(function(property) { var uri = ontology["base-uri"] + property.uri; %><option class="Rk-Edit-Vocabulary-Property" value="<%- uri %>'
                + '"<% if (uri === edge.uri) { %> selected<% } %>><%- renkan.translate(property.label) %></option>'
                + '<% }) %><% }) %></select></p><% } } %>'
                + '<% if (options.show_edge_editor_color) { %><div class="Rk-Editor-p"><span class="Rk-Editor-Label"><%-renkan.translate("Edge color:")%></span><div class="Rk-Edit-ColorPicker-Wrapper"><span class="Rk-Edit-Color" style="background:<%-edge.color%>;"><span class="Rk-Edit-ColorTip"></span></span>'
                + '<%= renkan.colorPicker %><span class="Rk-Edit-ColorPicker-Text"><%- renkan.translate("Choose color") %></span></div></div><% } %>'
                + '<% if (options.show_edge_editor_direction) { %><p><span class="Rk-Edit-Direction"><%- renkan.translate("Change edge direction") %></span></p><% } %>'
                + '<% if (options.show_edge_editor_nodes) { %><p><span class="Rk-Editor-Label"><%-renkan.translate("From:")%></span><span class="Rk-UserColor" style="background:<%-edge.from_color%>;"></span><%- shortenText(edge.from_title, 25) %></p>'
                + '<p><span class="Rk-Editor-Label"><%-renkan.translate("To:")%></span><span class="Rk-UserColor" style="background:<%-edge.to_color%>;"></span><%- shortenText(edge.to_title, 25) %></p><% } %>'
                + '<% if (options.show_edge_editor_creator && edge.has_creator) { %><p><span class="Rk-Editor-Label"><%-renkan.translate("Created by:")%></span><span class="Rk-UserColor" style="background:<%-edge.created_by_color%>;"></span><%- shortenText(edge.created_by_title, 25) %></p><% } %>'
        ),
        readOnlyTemplate: _.template(
                '<h2><span class="Rk-CloseX">&times;</span><% if (options.show_edge_tooltip_color) { %><span class="Rk-UserColor" style="background:<%-edge.color%>;"></span><% } %>'
                + '<span class="Rk-Display-Title"><% if (edge.uri) { %><a href="<%-edge.uri%>" target="_blank"><% } %><%-edge.title%><% if (edge.uri) { %></a><% } %></span></h2>'
                + '<% if (options.show_edge_tooltip_uri && edge.uri) { %><p class="Rk-Display-URI"><a href="<%-edge.uri%>" target="_blank"><%-edge.short_uri%></a></p><% } %>'
                + '<p><%-edge.description%></p>'
                + '<% if (options.show_edge_tooltip_nodes) { %><p><span class="Rk-Editor-Label"><%-renkan.translate("From:")%></span><span class="Rk-UserColor" style="background:<%-edge.from_color%>;"></span><%- shortenText(edge.from_title, 25) %></p>'
                + '<p><span class="Rk-Editor-Label"><%-renkan.translate("To:")%></span><span class="Rk-UserColor" style="background:<%-edge.to_color%>;"></span><%- shortenText(edge.to_title, 25) %></p><% } %>'
                + '<% if (options.show_edge_tooltip_creator && edge.has_creator) { %><p><span class="Rk-Editor-Label"><%-renkan.translate("Created by:")%></span><span class="Rk-UserColor" style="background:<%-edge.created_by_color%>;"></span><%- shortenText(edge.created_by_title, 25) %></p><% } %>'
        ),
        draw: function() {
            var _model = this.source_representation.model,
            _from_model = _model.get("from"),
            _to_model = _model.get("to"),
            _created_by = _model.get("created_by") || Utils._USER_PLACEHOLDER(this.renkan),
            _template = (this.renderer.isEditable() ? this.template : this.readOnlyTemplate);
            this.editor_$
            .html(_template({
                edge: {
                    has_creator: !!_model.get("created_by"),
                    title: _model.get("title"),
                    uri: _model.get("uri"),
                    short_uri:  Utils.shortenText((_model.get("uri") || "").replace(/^(https?:\/\/)?(www\.)?/,'').replace(/\/$/,''),40),
                    description: _model.get("description"),
                    color: _model.get("color") || _created_by.get("color"),
                    from_title: _from_model.get("title"),
                    to_title: _to_model.get("title"),
                    from_color: _from_model.get("color") || (_from_model.get("created_by") || Utils._USER_PLACEHOLDER(this.renkan)).get("color"),
                    to_color: _to_model.get("color") || (_to_model.get("created_by") || Utils._USER_PLACEHOLDER(this.renkan)).get("color"),
                    created_by_color: _created_by.get("color"),
                    created_by_title: _created_by.get("title")
                },
                renkan: this.renkan,
                shortenText: Utils.shortenText,
                options: this.options
            }));
            this.redraw();
            var _this = this,
            closeEditor = function() {
                _this.renderer.removeRepresentation(_this);
                paper.view.draw();
            };
            this.editor_$.find(".Rk-CloseX").click(closeEditor);
            this.editor_$.find(".Rk-Edit-Goto").click(function() {
                if (!_model.get("uri")) {
                    return false;
                }
            });

            if (this.renderer.isEditable()) {

                var onFieldChange = _(function() {
                    _(function() {
                        if (_this.renderer.isEditable()) {
                            var _data = {
                                    title: _this.editor_$.find(".Rk-Edit-Title").val()
                            };
                            if (_this.options.show_edge_editor_uri) {
                                _data.uri = _this.editor_$.find(".Rk-Edit-URI").val();
                            }
                            _this.editor_$.find(".Rk-Edit-Goto").attr("href",_data.uri || "#");
                            _model.set(_data);
                            paper.view.draw();
                        } else {
                            closeEditor();
                        }
                    }).defer();
                }).throttle(500);

                this.editor_$.on("keyup", function(_e) {
                    if (_e.keyCode === 27) {
                        closeEditor();
                    }
                });

                this.editor_$.find("input").on("keyup change paste", onFieldChange);

                this.editor_$.find(".Rk-Edit-Vocabulary").change(function() {
                    var e = $(this),
                    v = e.val();
                    if (v) {
                        _this.editor_$.find(".Rk-Edit-Title").val(e.find(":selected").text());
                        _this.editor_$.find(".Rk-Edit-URI").val(v);
                        onFieldChange();
                    }
                });
                this.editor_$.find(".Rk-Edit-Direction").click(function() {
                    if (_this.renderer.isEditable()) {
                        _model.set({
                            from: _model.get("to"),
                            to: _model.get("from")
                        });
                        _this.draw();
                    } else {
                        closeEditor();
                    }
                });

                var _picker = _this.editor_$.find(".Rk-Edit-ColorPicker");

                this.editor_$.find(".Rk-Edit-ColorPicker-Wrapper").hover(
                        function(_e) {
                            _e.preventDefault();
                            _picker.show();
                        },
                        function(_e) {
                            _e.preventDefault();
                            _picker.hide();
                        }
                );

                _picker.find("li").hover(
                        function(_e) {
                            _e.preventDefault();
                            _this.editor_$.find(".Rk-Edit-Color").css("background", $(this).attr("data-color"));
                        },
                        function(_e) {
                            _e.preventDefault();
                            _this.editor_$.find(".Rk-Edit-Color").css("background", _model.get("color") || (_model.get("created_by") || Utils._USER_PLACEHOLDER(_this.renkan)).get("color"));
                        }
                ).click(function(_e) {
                    _e.preventDefault();
                    if (_this.renderer.isEditable()) {
                        _model.set("color", $(this).attr("data-color"));
                        _picker.hide();
                        paper.view.draw();
                    } else {
                        closeEditor();
                    }
                });
            }
        },
        redraw: function() {
            var _coords = this.source_representation.paper_coords;
            Utils.drawEditBox(this.options, _coords, this.editor_block, 5, this.editor_$);
            this.editor_$.show();
            paper.view.draw();
        }
    });

    /* EdgeEditor End */
    
    return EdgeEditor;

});