/* Saves the Full JSON at each modification */

Rkns.jsonIO = function(_renkan, _opts) {
    var _proj = _renkan.project;
    if (typeof _opts.http_method == "undefined") {
        _opts.http_method = 'PUT';
    }
    var _load = function() {
        Rkns.$.getJSON(_opts.url, function(_data) {
            _proj.set(_data, {validate: true});
            _renkan.renderer.autoScale();
        });
    };
    var _save = function() {
        var _data = _proj.toJSON();
        if (!_renkan.read_only) {
            Rkns.$.ajax({
                type: _opts.http_method,
                url: _opts.url,
                contentType: "application/json",
                data: JSON.stringify(_data),
                success: function(data, textStatus, jqXHR) {
                }
            });
        }
        
    };
    var _thrSave = Rkns._.throttle(
        function() {
            setTimeout(_save, 100);
        }, 1000);
    _proj.on("add:nodes add:edges add:users add:views", function(_model) {
        _model.on("change remove", function(_model) {
            _thrSave();
        });
        _thrSave();
    });
    _proj.on("change", function() {
        _thrSave();
    });
        
    _load();
};
