"use strict";

define(['jquery', 'underscore', 'requtils', 'renderer/nodebutton'], function ($, _, requtils, NodeButton) {
    
    var Utils = requtils.getUtils();

    /* NodeShrinkButton Begin */

    //var NodeShrinkButton = Renderer.NodeShrinkButton = Utils.inherit(Renderer._NodeButton);
    var NodeShrinkButton = Utils.inherit(NodeButton);

    _(NodeShrinkButton.prototype).extend({
        _init: function() {
            this.type = "Node-shrink-button";
            this.lastSectorInner = 0;
            this.startAngle = -180;
            this.endAngle = -135;
            this.imageName = "shrink";
            this.text = "Shrink";
        },
        mouseup: function() {
            var _newsize = -1 + (this.source_representation.model.get("size") || 0);
            this.source_representation.model.set("size", _newsize);
            this.source_representation.select();
            this.select();
            paper.view.draw();
        }
    });

    /* NodeShrinkButton End */
    
    return NodeShrinkButton;

});