package org.iri_research.renkan.models;

import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

import org.iri_research.renkan.Constants;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection = "groups")
public class Group extends AbstractRenkanColoredModel<String> {

    private String avatar;
    private Set<String> users = new TreeSet<>();
    
    public Group() {
    }
    
    public Group(String id, String title, String description, String uri,
            String color) {
        super(id, title, description, uri, color);
        if(this.id == null) {
            this.id = Constants.UUID_GENERATOR.generate().toString();
        }
    }

    public String getAvatar() {
        return avatar;
    }
    
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getGroupName() {
        return this.getTitle();
    }

    @Override
    protected String getRawKeyPart() {
        return this.id;
    }
    
    public Set<String> getUsers() {
        if(this.users == null) {
            this.users = new TreeSet<>();
        }
        return this.users;
    }


    public boolean addUser(User user) {
        return this.addUser(user.getId());
    }
    
    public boolean addUser(String userId) {
        return this.getUsers().add(userId);
    }
    
    public boolean removeUser(User user) {
        return this.removeUser(user.getId());
    }
    
    public boolean removeUser(String userId) {
        if(this.getUsers() != null) {
            return this.getUsers().remove(userId);
        }
        return false;
    }
    
    @Override
    protected String getDefaultId() {
        return UUID.randomUUID().toString();
    }

}
