/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.joda.objects;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.LocaleResolver;

@Service
public class Joda {
    private static final String DEFAULT_STYLE = "MS";
    @Autowired
    private LocaleResolver localeResolver;
    @Autowired
    private HttpServletRequest servletRequest;

    public String format(DateTime dateTime) {
        return this.format(dateTime, DEFAULT_STYLE);
    }

    public String format(DateTime dateTime, String style) {
        String dateTimeString = "";
        if (dateTime != null) {
            dateTimeString = DateTimeFormat.forStyle((String)style).withLocale(this.getLocale()).print((ReadableInstant)dateTime);
        }
        return dateTimeString;
    }

    private Locale getLocale() {
        return this.localeResolver.resolveLocale(this.servletRequest);
    }
}

