
define(['jquery', 'underscore', 'requtils', 'renderer/nodebutton'], function ($, _, requtils, NodeButton) {
    'use strict';

    var Utils = requtils.getUtils();

    /* NodeRemoveButton Begin */

    //var NodeRemoveButton = Renderer.NodeRemoveButton = Utils.inherit(Renderer._NodeButton);
    var NodeRemoveButton = Utils.inherit(NodeButton);

    _(NodeRemoveButton.prototype).extend({
        _init: function() {
            this.type = "Node-remove-button";
            this.lastSectorInner = 0;
            this.startAngle = 0;
            this.endAngle = 60;
            this.imageName = "remove";
            this.text = "Remove";
        },
        mouseup: function() {
            this.renderer.click_target = null;
            this.renderer.is_dragging = false;
            this.renderer.removeRepresentationsOfType("editor");
            if (this.renderer.isEditable()) {
                if (this.options.element_delete_delay) {
                    var delid = Utils.getUID("delete");
                    this.renderer.delete_list.push({
                        id: delid,
                        time: new Date().valueOf() + this.options.element_delete_delay
                    });
                    this.source_representation.model.set("delete_scheduled", delid);
                } else {
                    if (confirm(this.renkan.translate('Do you really wish to remove node ') + '"' + this.source_representation.model.get("title") + '"?')) {
                        this.project.removeNode(this.source_representation.model);
                    }
                }
            }
        }
    }).value();

    /* NodeRemoveButton End */

    return NodeRemoveButton;

});
