package org.iri_research.renkan.controller.admin;

import javax.servlet.http.HttpServletRequest;

import org.iri_research.renkan.Constants;
import org.iri_research.renkan.controller.Utils;
import org.iri_research.renkan.models.User;
import org.iri_research.renkan.repositories.ProjectsRepository;
import org.iri_research.renkan.repositories.UsersRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.web.PageableDefaults;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping("/admin/users")
public class UsersAdminController {
		
	@SuppressWarnings("unused")
	private final Logger logger = LoggerFactory.getLogger(UsersAdminController.class);
	
	@Autowired
	private UsersRepository usersRepository;
	
	@Autowired
	private ProjectsRepository projectsRepository;
	
	@RequestMapping(value="/", method = RequestMethod.GET, produces={"text/html;charset=UTF-8"})
	public String usersList(
			Model model,
			@PageableDefaults(sort={"username"}, sortDir=Direction.DESC, pageNumber=0, value=Constants.PAGINATION_SIZE) Pageable p,
			HttpServletRequest request) {
		
		Page<User> page = this.usersRepository.findAll(p);
		
		model.addAttribute("page", page);
		model.addAttribute("baseUrl", Utils.buildBaseUrl(request));
		model.addAttribute("projectsCount", this.projectsRepository.getCountByUser());
		
		return "admin/usersList";
	}	

}
