var simplePersist = require('./data/simple-persist');

module.exports = function(grunt) {

  'use strict';

  var renkan_src = [
      'js/main.js',
      'js/models.js',
      'js/defaults.js',
      'js/i18n.js',
      'js/full-json.js',
      'js/ldtjson-bin.js',
      'js/list-bin.js',
      'js/wikipedia-bin.js',
      'dist/js/paper-renderer.js'
  ];

  var renkan_banner = grunt.file.read('js/header.js').toString() +
      '\n/*! <%= pkg.name %> - v<%= pkg.version %> - Copyright © IRI ' +
      '<%= grunt.template.today("yyyy") %> */\n\n';

  // Project configuration.
  grunt.initConfig({
    pkg: grunt.file.readJSON('package.json'),
    requirejs: {
      renderer: {
        options: {
          baseUrl: "js/",
          name: "main-renderer",
          out: "dist/js/paper-renderer.js",
          optimize: "none",
          beautify: true,
          paths: {
            requtils: "require-utils",
            jquery: "empty:",
            underscore: "empty:",
            filesaver: "empty:"
          }
        }
      }
    },
    uglify: {
      options: {
        banner: renkan_banner,
        sourceMap: true,
        sourceMapIncludeSources: true
      },
      renkan: {
        files : {
          'dist/js/renkan.min.js' : renkan_src
        }
      }
    },
    concat: {
      options: {
        banner: renkan_banner
      },
      renkan: {
        files : {
          'dist/js/renkan.js' : renkan_src
        }
      }
    },
    clean: {
      options: {
        force: true
      },
      renderer: ["dist/js/paper-renderer.js"],
      renkan: ["dist/"],
    },
    cssmin: {
      options: {
        banner: renkan_banner
      },
      renkan: {
        expand: true,
        cwd: 'css/',
        src: ['*.css'],
        dest: 'dist/css',
        ext: '.min.css'
      }
    },
    copy: {
      renkan: {
        files: [
          {expand: true, cwd: '', src: ['img/*'], dest: 'dist/', filter: 'isFile'},
          {expand: true, cwd: '', src: ['data/properties.json'], dest: 'dist/', filter: 'isFile'},
          {expand: true, cwd: '', src: ['lib/**'], dest: 'dist/'}
         ]
       },
       renkan_css: {
         options: {
           process: function (content, srcpath) {
             return grunt.template.process(renkan_banner) + content;
           }
         },
         files: [{expand: true, cwd: '', src: ['css/*'], dest: 'dist/', filter: 'isFile'}]
       }
    },
    jshint: {
      options: {
        curly: true,
        eqeqeq: true,
        eqnull: true,
        browser: true,
        globals: {
          jQuery: true
        },
      },
      all: ['Gruntfile.js', 'js/**/*.js', 'data/simple-persist.js']
    },
    connect: {
        server: {
          options: {
            port: 9001,
            base: '.',
            keepalive: true,
            useAvailablePort: true,
            debug: true,
            middleware: function(connect, options, middlewares) {
              middlewares.push(simplePersist.middleware);
              return middlewares;
            }
          },
        }
    }
  });

  // Load the plugin that provides the "uglify" task.
  grunt.loadNpmTasks('grunt-contrib-requirejs');
  grunt.loadNpmTasks('grunt-contrib-uglify');
  grunt.loadNpmTasks('grunt-contrib-concat');
  grunt.loadNpmTasks('grunt-contrib-clean');
  grunt.loadNpmTasks('grunt-contrib-cssmin');
  grunt.loadNpmTasks('grunt-contrib-copy');
  grunt.loadNpmTasks('grunt-contrib-jshint');
  grunt.loadNpmTasks('grunt-contrib-connect');

  // Default task(s).
  grunt.registerTask('default', ['jshint', 'requirejs', 'concat', 'uglify', 'cssmin', 'copy', 'clean:renderer']);


};
