package org.iri_research.renkan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.NoArgGenerator;

public class Constants {

    public final static String KEYHEX = "f2338d2299ac28ef64f82956fde37337b87a2b9e8fc03e28fa0768cac37d838113c7d0fc78c60fce1e23b1b3e03ac7db4676b3189c267f26baaab10f72544441";
    public final static int SALT_LENGTH = 24;
    public final static int PAGINATION_SIZE = 10;
    public final static String PROPERTIES_SERVLET_CONTEXT_NAME = "renkan.properties";
    public final static String PROPERTIES_CLASSPATH_NAME = "renkan_run.properties";
    public final static String ANONYMOUS_USER_BASE_NAME = "Anonymous";

    public final static String UNKNOWN_SCHEMA_VERSION = "1";
    public final static String SCHEMA_VERSION = "1";

    private final static EthernetAddress ETHERNET_ADRESS = EthernetAddress
            .fromInterface();
    public final static NoArgGenerator UUID_GENERATOR = Generators
            .timeBasedGenerator(ETHERNET_ADRESS);

    public enum EditMode {
        READ_ONLY(1), EDITION(2);

        private int value;

        private final static EditMode[] editModeValues = EditMode.values();

        private EditMode(int i) {
            this.value = i;
        }

        public static EditMode fromInt(int val) {
            for (int i = 0; i < editModeValues.length; i++) {
                if (editModeValues[i].value == val) {
                    return editModeValues[i];
                }
            }
            return null;
        }
    }


    public final static String ROLE_USER = "ROLE_USER";

    public final static List<String> USER_ROLES_SELECT = Collections
            .unmodifiableList(new ArrayList<String>() {
                private static final long serialVersionUID = -3041530185134732199L;
                {
                    add("ROLE_ADMIN");
                    add("ROLE_SPACES_ADMIN");
                    add("ROLE_GROUPS_ADMIN");
                }
            });

    public final static List<String> USER_ROLES_ALL = Collections
            .unmodifiableList(new ArrayList<String>() {
                private static final long serialVersionUID = -3041530185134732199L;
                {
                    add(ROLE_USER);
                    addAll(USER_ROLES_SELECT);
                }
            });
}
