/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.admin.security;

import org.coweb.CowebSecurityPolicy;
import org.coweb.SessionHandler;
import org.coweb.SessionManager;
import org.coweb.admin.Admin;
import org.coweb.admin.acls.SessionAcls;

public class SecurityPolicy
extends CowebSecurityPolicy {
    private Admin admin;

    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    public boolean canAdminRequest(String username, String key, boolean collab) {
        return this.canSubscribeToSession(username, key, collab);
    }

    public boolean canSubscribeToSession(String username, String key, boolean collab) {
        SessionAcls acls = this.admin.getSessionAclsForUser(username, key);
        if (acls == null) {
            return false;
        }
        return acls.canAccessSession();
    }

    public boolean canSubscribeToSession(String username, String sessionid) {
        SessionManager manager = SessionManager.getInstance();
        SessionHandler handler = manager.getSessionHandler(sessionid);
        return this.canSubscribeToSession(username, handler.getConfKey());
    }

    public boolean canInvokeServiceRequest(String username, String sessionid, String serviceName) {
        return true;
    }

    public boolean canSubscribeService(String username, String sessionid, String serviceName) {
        return true;
    }
}

