/*!
 *    _____            _
 *   |  __ \          | |
 *   | |__) |___ _ __ | | ____ _ _ __
 *   |  _  // _ \ '_ \| |/ / _` | '_ \
 *   | | \ \  __/ | | |   < (_| | | | |
 *   |_|  \_\___|_| |_|_|\_\__,_|_| |_|
 *
 *  Copyright 2012-2015 Institut de recherche et d'innovation
 *  contributor(s) : Yves-Marie Haussonne, Raphael Velt, Samuel Huron,
 *      Thibaut Cavalié, Julien Rougeron.
 *
 *  contact@iri.centrepompidou.fr
 *  http://www.iri.centrepompidou.fr
 *
 *  This software is a computer program whose purpose is to show and add annotations on a video .
 *  This software is governed by the CeCILL-C license under French law and
 *  abiding by the rules of distribution of free software. You can  use,
 *  modify and/ or redistribute the software under the terms of the CeCILL-C
 *  license as circulated by CEA, CNRS and INRIA at the following URL
 *  "http://www.cecill.info".
 *
 *  The fact that you are presently reading this means that you have had
 *  knowledge of the CeCILL-C license and that you accept its terms.
 */

/*! renkan - v0.10.0 - Copyright © IRI 2015 */

this["renkanJST"] = this["renkanJST"] || {};

this["renkanJST"]["templates/colorpicker.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape;
with (obj) {
__p += '<li data-color="' +
((__t = (c)) == null ? '' : __t) +
'" style="background: ' +
((__t = (c)) == null ? '' : __t) +
'"></li>';

}
return __p
};

this["renkanJST"]["templates/edgeeditor.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
with (obj) {
__p += '<h2>\n    <span class="Rk-CloseX">&times;</span>' +
__e(renkan.translate("Edit Edge")) +
'</span>\n</h2>\n<p>\n    <label>' +
__e(renkan.translate("Title:")) +
'</label>\n    <input class="Rk-Edit-Title" type="text" value="' +
__e(edge.title) +
'" />\n</p>\n';
 if (options.show_edge_editor_uri) { ;
__p += '\n    <p>\n        <label>' +
__e(renkan.translate("URI:")) +
'</label>\n        <input class="Rk-Edit-URI" type="text" value="' +
__e(edge.uri) +
'" />\n        <a class="Rk-Edit-Goto" href="' +
__e(edge.uri) +
'" target="_blank"></a>\n    </p>\n    ';
 if (options.properties.length) { ;
__p += '\n        <p>\n            <label>' +
__e(renkan.translate("Choose from vocabulary:")) +
'</label>\n            <select class="Rk-Edit-Vocabulary">\n                ';
 _.each(options.properties, function(ontology) { ;
__p += '\n                    <option class="Rk-Edit-Vocabulary-Class" value="">\n                        ' +
__e( renkan.translate(ontology.label) ) +
'\n                    </option>\n                    ';
 _.each(ontology.properties, function(property) { var uri = ontology["base-uri"] + property.uri; ;
__p += '\n                        <option class="Rk-Edit-Vocabulary-Property" value="' +
__e( uri ) +
'"\n                            ';
 if (uri === edge.uri) { ;
__p += ' selected';
 } ;
__p += '>\n                            ' +
__e( renkan.translate(property.label) ) +
'\n                        </option>\n                    ';
 }) ;
__p += '\n                ';
 }) ;
__p += '\n            </select>\n        </p>\n';
 } } ;
__p += '\n';
 if (options.show_edge_editor_style) { ;
__p += '\n    <div class="Rk-Editor-p">\n      ';
 if (options.show_edge_editor_style_color) { ;
__p += '\n      <div id="Rk-Editor-p-color">\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Edge color:")) +
'</span>\n        <div class="Rk-Edit-ColorPicker-Wrapper">\n            <span class="Rk-Edit-Color" style="background: &lt;%-edge.color%>;">\n                <span class="Rk-Edit-ColorTip"></span>\n            </span>\n            ' +
((__t = ( renkan.colorPicker )) == null ? '' : __t) +
'\n            <span class="Rk-Edit-ColorPicker-Text">' +
__e( renkan.translate("Choose color") ) +
'</span>\n        </div>\n      </div>\n      ';
 } ;
__p += '\n      ';
 if (options.show_edge_editor_style_dash) { ;
__p += '\n      <div id="Rk-Editor-p-dash">\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Dash:")) +
'</span>\n        <input type="checkbox" name="Rk-Edit-Dash" class="Rk-Edit-Dash" ' +
__e( edge.dash ) +
' />\n      </div>\n      ';
 } ;
__p += '\n      ';
 if (options.show_edge_editor_style_thickness) { ;
__p += '\n      <div id="Rk-Editor-p-thickness">\n          <span class="Rk-Editor-Label">' +
__e(renkan.translate("Thickness:")) +
'</span>\n          <a href="#" class="Rk-Edit-Size-Btn" id="Rk-Edit-Thickness-Down">-</a>\n          <span class="Rk-Edit-Size-Disp" id="Rk-Edit-Thickness-Value">' +
__e( edge.thickness ) +
'</span>\n          <a href="#" class="Rk-Edit-Size-Btn" id="Rk-Edit-Thickness-Up">+</a>\n      </div>\n      ';
 } ;
__p += '\n      ';
 if (options.show_edge_editor_style_arrow) { ;
__p += '\n      <div id="Rk-Editor-p-arrow">\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Arrow:")) +
'</span>\n        <input type="checkbox" name="Rk-Edit-Arrow" class="Rk-Edit-Arrow" ' +
__e( edge.arrow ) +
' />\n      </div>\n      ';
 } ;
__p += '\n    </div>\n';
 } ;
__p += '\n';
 if (options.show_edge_editor_direction) { ;
__p += '\n    <p>\n        <span class="Rk-Edit-Direction">' +
__e( renkan.translate("Change edge direction") ) +
'</span>\n    </p>\n';
 } ;
__p += '\n';
 if (options.show_edge_editor_nodes) { ;
__p += '\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("From:")) +
'</span>\n        <span class="Rk-UserColor" style="background: ' +
__e(edge.from_color) +
';"></span>\n        ' +
__e( shortenText(edge.from_title, 25) ) +
'\n    </p>\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("To:")) +
'</span>\n        <span class="Rk-UserColor" style="background: >%-edge.to_color%>;"></span>\n        ' +
__e( shortenText(edge.to_title, 25) ) +
'\n    </p>\n';
 } ;
__p += '\n';
 if (options.show_edge_editor_creator && edge.has_creator) { ;
__p += '\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Created by:")) +
'</span>\n        <span class="Rk-UserColor" style="background: &lt;%-edge.created_by_color%>;"></span>\n        ' +
__e( shortenText(edge.created_by_title, 25) ) +
'\n    </p>\n';
 } ;
__p += '\n';

}
return __p
};

this["renkanJST"]["templates/edgeeditor_readonly.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
with (obj) {
__p += '<h2>\n    <span class="Rk-CloseX">&times;</span>\n    ';
 if (options.show_edge_tooltip_color) { ;
__p += '\n        <span class="Rk-UserColor" style="background: ' +
__e( edge.color ) +
';"></span>\n    ';
 } ;
__p += '\n    <span class="Rk-Display-Title">\n        ';
 if (edge.uri) { ;
__p += '\n            <a href="' +
__e(edge.uri) +
'" target="_blank">\n        ';
 } ;
__p += '\n        ' +
__e(edge.title) +
'\n        ';
 if (edge.uri) { ;
__p += ' </a> ';
 } ;
__p += '\n    </span>\n</h2>\n';
 if (options.show_edge_tooltip_uri && edge.uri) { ;
__p += '\n    <p class="Rk-Display-URI">\n        <a href="' +
__e(edge.uri) +
'" target="_blank">' +
__e( edge.short_uri ) +
'</a>\n    </p>\n';
 } ;
__p += '\n<p>' +
((__t = (edge.description)) == null ? '' : __t) +
'</p>\n';
 if (options.show_edge_tooltip_nodes) { ;
__p += '\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("From:")) +
'</span>\n        <span class="Rk-UserColor" style="background: ' +
__e( edge.from_color ) +
';"></span>\n        ' +
__e( shortenText(edge.from_title, 25) ) +
'\n    </p>\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("To:")) +
'</span>\n        <span class="Rk-UserColor" style="background: ' +
__e( edge.to_color ) +
';"></span>\n        ' +
__e( shortenText(edge.to_title, 25) ) +
'\n    </p>\n';
 } ;
__p += '\n';
 if (options.show_edge_tooltip_creator && edge.has_creator) { ;
__p += '\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Created by:")) +
'</span>\n        <span class="Rk-UserColor" style="background: ' +
__e( edge.created_by_color ) +
';"></span>\n        ' +
__e( shortenText(edge.created_by_title, 25) ) +
'\n    </p>\n';
 } ;
__p += '\n';

}
return __p
};

this["renkanJST"]["templates/ldtjson-bin/annotationtemplate.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape;
with (obj) {
__p += '<li class="Rk-Bin-Item" draggable="true"\n    data-image="' +
__e( Rkns.Utils.getFullURL(image) ) +
'"\n    data-uri="' +
((__t = (ldt_platform)) == null ? '' : __t) +
'ldtplatform/ldt/front/player/' +
((__t = (mediaid)) == null ? '' : __t) +
'/#id=' +
((__t = (annotationid)) == null ? '' : __t) +
'"\n    data-title="' +
__e(title) +
'" data-description="' +
__e(description) +
'">\n\n    <img class="Rk-Ldt-Annotation-Icon" src="' +
((__t = (image)) == null ? '' : __t) +
'" />\n    <h4>' +
((__t = (htitle)) == null ? '' : __t) +
'</h4>\n    <p>' +
((__t = (hdescription)) == null ? '' : __t) +
'</p>\n    <p>Start: ' +
((__t = (start)) == null ? '' : __t) +
', End: ' +
((__t = (end)) == null ? '' : __t) +
', Duration: ' +
((__t = (duration)) == null ? '' : __t) +
'</p>\n    <div class="Rk-Clear"></div>\n</li>\n';

}
return __p
};

this["renkanJST"]["templates/ldtjson-bin/segmenttemplate.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape;
with (obj) {
__p += '<li class="Rk-Bin-Item" draggable="true"\n    data-image="' +
__e( Rkns.Utils.getFullURL(image) ) +
'"\n    data-uri="' +
((__t = (ldt_platform)) == null ? '' : __t) +
'ldtplatform/ldt/front/player/' +
((__t = (mediaid)) == null ? '' : __t) +
'/#id=' +
((__t = (annotationid)) == null ? '' : __t) +
'"\n    data-title="' +
__e(title) +
'" data-description="' +
__e(description) +
'">\n\n    <img class="Rk-Ldt-Annotation-Icon" src="' +
((__t = (image)) == null ? '' : __t) +
'" />\n    <h4>' +
((__t = (htitle)) == null ? '' : __t) +
'</h4>\n    <p>' +
((__t = (hdescription)) == null ? '' : __t) +
'</p>\n    <p>Start: ' +
((__t = (start)) == null ? '' : __t) +
', End: ' +
((__t = (end)) == null ? '' : __t) +
', Duration: ' +
((__t = (duration)) == null ? '' : __t) +
'</p>\n    <div class="Rk-Clear"></div>\n</li>\n';

}
return __p
};

this["renkanJST"]["templates/ldtjson-bin/tagtemplate.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape;
with (obj) {
__p += '<li class="Rk-Bin-Item" draggable="true"\n    data-image="' +
__e( Rkns.Utils.getFullURL(static_url+'img/ldt-tag.png') ) +
'"\n    data-uri="' +
((__t = (ldt_platform)) == null ? '' : __t) +
'ldtplatform/ldt/front/search/?search=' +
((__t = (encodedtitle)) == null ? '' : __t) +
'&field=all"\n    data-title="' +
__e(title) +
'" data-description="Tag \'' +
__e(title) +
'\'">\n\n    <img class="Rk-Ldt-Tag-Icon" src="' +
__e(static_url) +
'img/ldt-tag.png" />\n    <h4>' +
((__t = (htitle)) == null ? '' : __t) +
'</h4>\n    <div class="Rk-Clear"></div>\n</li>\n';

}
return __p
};

this["renkanJST"]["templates/list-bin.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
with (obj) {
__p += '<li class="Rk-Bin-Item Rk-ResourceList-Item" draggable="true"\n    data-uri="' +
__e(url) +
'" data-title="' +
__e(title) +
'"\n    data-description="' +
__e(description) +
'"\n    ';
 if (image) { ;
__p += '\n        data-image="' +
__e( Rkns.Utils.getFullURL(image) ) +
'"\n    ';
 } else { ;
__p += '\n        data-image=""\n    ';
 } ;
__p += '\n>';
 if (image) { ;
__p += '\n    <img class="Rk-ResourceList-Image" src="' +
__e(image) +
'" />\n';
 } ;
__p += '\n<h4 class="Rk-ResourceList-Title">\n    ';
 if (url) { ;
__p += '\n        <a href="' +
__e(url) +
'" target="_blank">\n    ';
 } ;
__p += '\n    ' +
((__t = (htitle)) == null ? '' : __t) +
'\n    ';
 if (url) { ;
__p += '</a>';
 } ;
__p += '\n    </h4>\n    ';
 if (description) { ;
__p += '\n        <p class="Rk-ResourceList-Description">' +
((__t = (hdescription)) == null ? '' : __t) +
'</p>\n    ';
 } ;
__p += '\n    ';
 if (image) { ;
__p += '\n        <div style="clear: both;"></div>\n    ';
 } ;
__p += '\n</li>\n';

}
return __p
};

this["renkanJST"]["templates/main.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
with (obj) {

 if (options.show_bins) { ;
__p += '\n    <div class="Rk-Bins">\n        <div class="Rk-Bins-Head">\n            <h2 class="Rk-Bins-Title">' +
__e( translate("Select contents:")) +
'</h2>\n            <form class="Rk-Web-Search-Form Rk-Search-Form">\n                <input class="Rk-Web-Search-Input Rk-Search-Input" type="search"\n                    placeholder="' +
__e( translate('Search the Web') ) +
'" />\n                <div class="Rk-Search-Select">\n                    <div class="Rk-Search-Current"></div>\n                    <ul class="Rk-Search-List"></ul>\n                </div>\n                <input type="submit" value=""\n                    class="Rk-Web-Search-Submit Rk-Search-Submit" title="' +
__e( translate('Search the Web') ) +
'" />\n            </form>\n            <form class="Rk-Bins-Search-Form Rk-Search-Form">\n                <input class="Rk-Bins-Search-Input Rk-Search-Input" type="search"\n                    placeholder="' +
__e( translate('Search in Bins') ) +
'" /> <input\n                    type="submit" value=""\n                    class="Rk-Bins-Search-Submit Rk-Search-Submit"\n                    title="' +
__e( translate('Search in Bins') ) +
'" />\n            </form>\n        </div>\n        <ul class="Rk-Bin-List"></ul>\n    </div>\n';
 } ;
__p += ' ';
 if (options.show_editor) { ;
__p += '\n    <div class="Rk-Render Rk-Render-';
 if (options.show_bins) { ;
__p += 'Panel';
 } else { ;
__p += 'Full';
 } ;
__p += '"></div>\n';
 } ;
__p += '\n';

}
return __p
};

this["renkanJST"]["templates/nodeeditor.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
with (obj) {

 //TODO: change class to id ;
__p += '\n<h2>\n    <span class="Rk-CloseX">&times;</span>' +
__e(renkan.translate("Edit Node")) +
'</span>\n</h2>\n<p>\n    <label>' +
__e(renkan.translate("Title:")) +
'</label>\n    <input class="Rk-Edit-Title" type="text" value="' +
__e(node.title) +
'" />\n</p>\n';
 if (options.show_node_editor_uri) { ;
__p += '\n    <p>\n        <label>' +
__e(renkan.translate("URI:")) +
'</label>\n        <input class="Rk-Edit-URI" type="text" value="' +
__e(node.uri) +
'" />\n        <a class="Rk-Edit-Goto" href="' +
__e(node.uri) +
'" target="_blank"></a>\n    </p>\n';
 } ;
__p += ' ';
 if (options.change_types) { ;
__p += '\n    <p>\n        <label>' +
__e(renkan.translate("Types available")) +
':</label>\n        <select class="Rk-Edit-Type">\n          ';
 _.each(types, function(type) { ;
__p += '\n            <option class="Rk-Edit-Vocabulary-Property" value="' +
__e( type ) +
'"';
 if (node.type === type) { ;
__p += ' selected';
 } ;
__p += '>\n                ' +
__e( renkan.translate(type.charAt(0).toUpperCase() + type.substring(1)) ) +
'\n            </option>\n          ';
 }); ;
__p += '\n        </select>\n    </p>\n';
 } ;
__p += ' ';
 if (options.show_node_editor_description) { ;
__p += '\n    <p>\n        <label>' +
__e(renkan.translate("Description:")) +
'</label>\n        ';
 if (options.show_node_editor_description_richtext) { ;
__p += '\n            <div class="Rk-Edit-Description" contenteditable="true">' +
((__t = (node.description)) == null ? '' : __t) +
'</div>\n        ';
 } else { ;
__p += '\n            <textarea class="Rk-Edit-Description">' +
((__t = (node.description)) == null ? '' : __t) +
'</textarea>\n        ';
 } ;
__p += '\n    </p>\n';
 } ;
__p += ' ';
 if (options.show_node_editor_size) { ;
__p += '\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Size:")) +
'</span>\n        <a href="#" class="Rk-Edit-Size-Btn" id="Rk-Edit-Size-Down">-</a>\n        <span class="Rk-Edit-Size-Disp" id="Rk-Edit-Size-Value">' +
__e(node.size) +
'</span>\n        <a href="#" class="Rk-Edit-Size-Btn" id="Rk-Edit-Size-Up">+</a>\n    </p>\n';
 } ;
__p += ' ';
 if (options.show_node_editor_style) { ;
__p += '\n    <div class="Rk-Editor-p">\n      ';
 if (options.show_node_editor_style_color) { ;
__p += '\n      <div id="Rk-Editor-p-color">\n        <span class="Rk-Editor-Label">\n        ' +
__e(renkan.translate("Node color:")) +
'</span>\n        <div class="Rk-Edit-ColorPicker-Wrapper">\n            <span class="Rk-Edit-Color" style="background: ' +
__e(node.color) +
';">\n                <span class="Rk-Edit-ColorTip"></span>\n            </span>\n            ' +
((__t = ( renkan.colorPicker )) == null ? '' : __t) +
'\n            <span class="Rk-Edit-ColorPicker-Text">' +
__e( renkan.translate("Choose color") ) +
'</span>\n        </div>\n      </div>\n      ';
 } ;
__p += '\n      ';
 if (options.show_node_editor_style_dash) { ;
__p += '\n      <div id="Rk-Editor-p-dash">\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Dash:")) +
'</span>\n        <input type="checkbox" name="Rk-Edit-Dash" class="Rk-Edit-Dash" ' +
__e( node.dash ) +
' />\n      </div>\n      ';
 } ;
__p += '\n      ';
 if (options.show_node_editor_style_thickness) { ;
__p += '\n      <div id="Rk-Editor-p-thickness">\n          <span class="Rk-Editor-Label">' +
__e(renkan.translate("Thickness:")) +
'</span>\n          <a href="#" class="Rk-Edit-Size-Btn" id="Rk-Edit-Thickness-Down">-</a>\n          <span class="Rk-Edit-Size-Disp" id="Rk-Edit-Thickness-Value">' +
__e(node.thickness) +
'</span>\n          <a href="#" class="Rk-Edit-Size-Btn" id="Rk-Edit-Thickness-Up">+</a>\n      </div>\n      ';
 } ;
__p += '\n    </div>\n';
 } ;
__p += ' ';
 if (options.show_node_editor_image) { ;
__p += '\n    <div class="Rk-Edit-ImgWrap">\n        <div class="Rk-Edit-ImgPreview">\n            <img src="' +
__e(node.image || node.image_placeholder) +
'" />\n            ';
 if (node.clip_path) { ;
__p += '\n                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewbox="0 0 1 1" preserveAspectRatio="none">\n                    <path style="stroke-width: .02; stroke:red; fill-opacity:.3; fill:red;" d="' +
__e( node.clip_path ) +
'" />\n                </svg>\n            ';
 };
__p += '\n        </div>\n    </div>\n    <p>\n        <label>' +
__e(renkan.translate("Image URL:")) +
'</label>\n        <div>\n            <a class="Rk-Edit-Image-Del" href="#"></a>\n            <input class="Rk-Edit-Image" type="text" value=\'' +
__e(node.image) +
'\' />\n        </div>\n    </p>\n';
 if (options.allow_image_upload) { ;
__p += '\n    <p>\n        <label>' +
__e(renkan.translate("Choose Image File:")) +
'</label>\n        <input class="Rk-Edit-Image-File" type="file" accept="image/*" />\n    </p>\n';
 };

 } ;
__p += ' ';
 if (options.show_node_editor_creator && node.has_creator) { ;
__p += '\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Created by:")) +
'</span>\n        <span class="Rk-UserColor" style="background: ' +
__e(node.created_by_color) +
';"></span>\n        ' +
__e( shortenText(node.created_by_title, 25) ) +
'\n    </p>\n';
 } ;
__p += ' ';
 if (options.change_shapes) { ;
__p += '\n    <p>\n        <label>' +
__e(renkan.translate("Shapes available")) +
':</label>\n        <select class="Rk-Edit-Shape">\n          ';
 _.each(shapes, function(shape) { ;
__p += '\n            <option class="Rk-Edit-Vocabulary-Property" value="' +
__e( shape ) +
'"';
 if (node.shape === shape) { ;
__p += ' selected';
 } ;
__p += '>\n                ' +
__e( renkan.translate(shape.charAt(0).toUpperCase() + shape.substring(1)) ) +
'\n            </option>\n          ';
 }); ;
__p += '\n        </select>\n    </p>\n';
 } ;
__p += '\n';

}
return __p
};

this["renkanJST"]["templates/nodeeditor_readonly.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
with (obj) {
__p += '<h2>\n    <span class="Rk-CloseX">&times;</span>\n    ';
 if (options.show_node_tooltip_color) { ;
__p += '\n        <span class="Rk-UserColor" style="background: ' +
__e(node.color) +
';"></span>\n    ';
 } ;
__p += '\n    <span class="Rk-Display-Title">\n        ';
 if (node.uri) { ;
__p += '\n            <a href="' +
__e(node.uri) +
'" target="_blank">\n        ';
 } ;
__p += '\n        ' +
__e(node.title) +
'\n        ';
 if (node.uri) { ;
__p += '</a>';
 } ;
__p += '\n    </span>\n</h2>\n';
 if (node.uri && options.show_node_tooltip_uri) { ;
__p += '\n    <p class="Rk-Display-URI">\n        <a href="' +
__e(node.uri) +
'" target="_blank">' +
__e(node.short_uri) +
'</a>\n    </p>\n';
 } ;
__p += ' ';
 if (options.show_node_tooltip_description) { ;
__p += '\n    <p class="Rk-Display-Description">' +
((__t = (node.description)) == null ? '' : __t) +
'</p>\n';
 } ;
__p += ' ';
 if (node.image && options.show_node_tooltip_image) { ;
__p += '\n    <img class="Rk-Display-ImgPreview" src="' +
__e(node.image) +
'" />\n';
 } ;
__p += ' ';
 if (node.has_creator && options.show_node_tooltip_creator) { ;
__p += '\n    <p>\n        <span class="Rk-Editor-Label">' +
__e(renkan.translate("Created by:")) +
'</span>\n        <span class="Rk-UserColor" style="background: ' +
__e(node.created_by_color) +
';"></span>\n        ' +
__e( shortenText(node.created_by_title, 25) ) +
'\n    </p>\n';
 } ;
__p += '\n    <a href="#?idnode=' +
__e(node._id) +
'">' +
__e(renkan.translate("Link to the node")) +
'</a>\n';

}
return __p
};

this["renkanJST"]["templates/nodeeditor_video.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
with (obj) {
__p += '<h2>\n    <span class="Rk-CloseX">&times;</span>\n    ';
 if (options.show_node_tooltip_color) { ;
__p += '\n        <span class="Rk-UserColor" style="background: ' +
__e(node.color) +
';"></span>\n    ';
 } ;
__p += '\n    <span class="Rk-Display-Title">\n        ';
 if (node.uri) { ;
__p += '\n            <a href="' +
__e(node.uri) +
'" target="_blank">\n        ';
 } ;
__p += '\n        ' +
__e(node.title) +
'\n        ';
 if (node.uri) { ;
__p += '</a>';
 } ;
__p += '\n    </span>\n</h2>\n';
 if (node.uri && options.show_node_tooltip_uri) { ;
__p += '\n     <video width="320" height="240" controls>\n        <source src="' +
__e(node.uri) +
'" type="video/mp4">\n     </video> \n';
 } ;
__p += '\n    <a href="#?idnode=' +
__e(node._id) +
'">' +
__e(renkan.translate("Link to the node")) +
'</a>\n';

}
return __p
};

this["renkanJST"]["templates/scene.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
with (obj) {

 if (options.show_top_bar) { ;
__p += '\n    <div class="Rk-TopBar">\n        <div class="loader"></div>\n        ';
 if (!options.editor_mode) { ;
__p += '\n            <h2 class="Rk-PadTitle">\n                ' +
__e( project.get("title") || translate("Untitled project")) +
'\n            </h2>\n        ';
 } else { ;
__p += '\n            <input type="text" class="Rk-PadTitle" value="' +
__e( project.get('title') || '' ) +
'" placeholder="' +
__e(translate('Untitled project')) +
'" />\n        ';
 } ;
__p += '\n        ';
 if (options.show_user_list) { ;
__p += '\n            <div class="Rk-Users">\n                <div class="Rk-CurrentUser">\n                    ';
 if (options.show_user_color) { ;
__p += '\n                        <div class="Rk-Edit-ColorPicker-Wrapper">\n                            <span class="Rk-CurrentUser-Color">\n                            ';
 if (options.user_color_editable) { ;
__p += '\n                                <span class="Rk-Edit-ColorTip"></span>\n                            ';
 } ;
__p += '\n                            </span>\n                            ';
 if (options.user_color_editable) { print(colorPicker) } ;
__p += '\n                        </div>\n                    ';
 } ;
__p += '\n                    <span class="Rk-CurrentUser-Name">&lt;unknown user&gt;</span>\n                </div>\n                <ul class="Rk-UserList"></ul>\n            </div>\n        ';
 } ;
__p += '\n        ';
 if (options.home_button_url) {;
__p += '\n            <div class="Rk-TopBar-Separator"></div>\n            <a class="Rk-TopBar-Button Rk-Home-Button" href="' +
__e( options.home_button_url ) +
'">\n                <div class="Rk-TopBar-Tooltip">\n                    <div class="Rk-TopBar-Tooltip-Contents">\n                        ' +
__e( translate(options.home_button_title) ) +
'\n                    </div>\n                </div>\n            </a>\n        ';
 } ;
__p += '\n        ';
 if (options.show_fullscreen_button) { ;
__p += '\n            <div class="Rk-TopBar-Separator"></div>\n            <div class="Rk-TopBar-Button Rk-FullScreen-Button">\n                <div class="Rk-TopBar-Tooltip">\n                    <div class="Rk-TopBar-Tooltip-Contents">\n                        ' +
__e(translate("Full Screen")) +
'\n                    </div>\n                </div>\n            </div>\n        ';
 } ;
__p += '\n        ';
 if (options.editor_mode) { ;
__p += '\n            ';
 if (options.show_addnode_button) { ;
__p += '\n                <div class="Rk-TopBar-Separator"></div>\n                <div class="Rk-TopBar-Button Rk-AddNode-Button">\n                    <div class="Rk-TopBar-Tooltip">\n                        <div class="Rk-TopBar-Tooltip-Contents">\n                            ' +
__e(translate("Add Node")) +
'\n                        </div>\n                    </div>\n                </div>\n            ';
 } ;
__p += '\n            ';
 if (options.show_addedge_button) { ;
__p += '\n                <div class="Rk-TopBar-Separator"></div>\n                <div class="Rk-TopBar-Button Rk-AddEdge-Button">\n                    <div class="Rk-TopBar-Tooltip">\n                        <div class="Rk-TopBar-Tooltip-Contents">\n                            ' +
__e(translate("Add Edge")) +
'\n                        </div>\n                    </div>\n                </div>\n            ';
 } ;
__p += '\n            ';
 if (options.show_export_button) { ;
__p += '\n                <div class="Rk-TopBar-Separator"></div>\n                <div class="Rk-TopBar-Button Rk-Export-Button">\n                    <div class="Rk-TopBar-Tooltip">\n                        <div class="Rk-TopBar-Tooltip-Contents">\n                            ' +
__e(translate("Download Project")) +
'\n                        </div>\n                    </div>\n                </div>\n            ';
 } ;
__p += '\n            ';
 if (options.show_save_button) { ;
__p += '\n                <div class="Rk-TopBar-Separator"></div>\n                <div class="Rk-TopBar-Button Rk-Save-Button">\n                    <div class="Rk-TopBar-Tooltip">\n                        <div class="Rk-TopBar-Tooltip-Contents"></div>\n                    </div>\n                </div>\n            ';
 } ;
__p += '\n            ';
 if (options.show_open_button) { ;
__p += '\n                <div class="Rk-TopBar-Separator"></div>\n                <div class="Rk-TopBar-Button Rk-Open-Button">\n                    <div class="Rk-TopBar-Tooltip">\n                        <div class="Rk-TopBar-Tooltip-Contents">\n                            ' +
__e(translate("Open Project")) +
'\n                        </div>\n                    </div>\n                </div>\n            ';
 } ;
__p += '\n            ';
 if (options.show_bookmarklet) { ;
__p += '\n                <div class="Rk-TopBar-Separator"></div>\n                <a class="Rk-TopBar-Button Rk-Bookmarklet-Button" href="#">\n                    <div class="Rk-TopBar-Tooltip">\n                        <div class="Rk-TopBar-Tooltip-Contents">\n                            ' +
__e(translate("Renkan \'Drag-to-Add\' bookmarklet")) +
'\n                        </div>\n                    </div>\n                </a>\n                <div class="Rk-TopBar-Separator"></div>\n            ';
 } ;
__p += '\n        ';
 } else { ;
__p += '\n            ';
 if (options.show_export_button) { ;
__p += '\n                <div class="Rk-TopBar-Separator"></div>\n                <div class="Rk-TopBar-Button Rk-Export-Button">\n                    <div class="Rk-TopBar-Tooltip">\n                        <div class="Rk-TopBar-Tooltip-Contents">\n                            ' +
__e(translate("Download Project")) +
'\n                        </div>\n                    </div>\n                </div>\n                <div class="Rk-TopBar-Separator"></div>\n            ';
 } ;
__p += '\n        ';
 }; ;
__p += '\n        ';
 if (options.show_search_field) { ;
__p += '\n            <form action="#" class="Rk-GraphSearch-Form">\n                <input type="search" class="Rk-GraphSearch-Field" placeholder="' +
__e( translate('Search in graph') ) +
'" />\n            </form>\n            <div class="Rk-TopBar-Separator"></div>\n        ';
 } ;
__p += '\n    </div>\n';
 } ;
__p += '\n<div class="Rk-Editing-Space';
 if (!options.show_top_bar) { ;
__p += ' Rk-Editing-Space-Full';
 } ;
__p += '">\n    <div class="Rk-Labels"></div>\n    <canvas class="Rk-Canvas" ';
 if (options.resize) { ;
__p += ' resize="" ';
 } ;
__p += ' ></canvas>\n    <div class="Rk-Notifications"></div>\n    <div class="Rk-Editor">\n        ';
 if (options.show_bins) { ;
__p += '\n            <div class="Rk-Fold-Bins">&laquo;</div>\n        ';
 } ;
__p += '\n        ';
 if (options.show_zoom) { ;
__p += '\n            <div class="Rk-ZoomButtons">\n                <div class="Rk-ZoomIn" title="' +
__e(translate('Zoom In')) +
'"></div>\n                <div class="Rk-ZoomFit" title="' +
__e(translate('Zoom Fit')) +
'"></div>\n                <div class="Rk-ZoomOut" title="' +
__e(translate('Zoom Out')) +
'"></div>\n                ';
 if (options.editor_mode && options.save_view) { ;
__p += '\n                    <div class="Rk-ZoomSave" title="' +
__e(translate('Save view')) +
'"></div>\n                ';
 } ;
__p += '\n                ';
 if (options.save_view) { ;
__p += '\n                    <div class="Rk-ZoomSetSaved" title="' +
__e(translate('View saved view')) +
'"></div>\n                    ';
 if (options.hide_nodes) { ;
__p += '\n                \t   <div class="Rk-ShowHiddenNodes" title="' +
__e(translate('Show hidden nodes')) +
'"></div>\n                    ';
 } ;
__p += '       \n                ';
 } ;
__p += '\n            </div>\n        ';
 } ;
__p += '\n    </div>\n</div>\n';

}
return __p
};

this["renkanJST"]["templates/search.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape;
with (obj) {
__p += '<li class="' +
((__t = ( className )) == null ? '' : __t) +
'" data-key="' +
((__t = ( key )) == null ? '' : __t) +
'">' +
((__t = ( title )) == null ? '' : __t) +
'</li>';

}
return __p
};

this["renkanJST"]["templates/wikipedia-bin/resulttemplate.html"] = function(obj) {
obj || (obj = {});
var __t, __p = '', __e = _.escape;
with (obj) {
__p += '<li class="Rk-Wikipedia-Result Rk-Bin-Item" draggable="true"\n    data-uri="' +
__e(url) +
'" data-title="Wikipedia: ' +
__e(title) +
'"\n    data-description="' +
__e(description) +
'"\n    data-image="' +
__e( Rkns.Utils.getFullURL( static_url + 'img/wikipedia.png' ) ) +
'">\n\n    <img class="Rk-Wikipedia-Icon" src="' +
__e(static_url) +
'img/wikipedia.png">\n    <h4 class="Rk-Wikipedia-Title">\n        <a href="' +
__e(url) +
'" target="_blank">' +
((__t = (htitle)) == null ? '' : __t) +
'</a>\n    </h4>\n    <p class="Rk-Wikipedia-Snippet">' +
((__t = (hdescription)) == null ? '' : __t) +
'</p>\n</li>\n';

}
return __p
};
/* Declaring the Renkan Namespace Rkns and Default values */

(function(root) {

    "use strict";

    if (typeof root.Rkns !== "object") {
        root.Rkns = {};
    }

    var Rkns = root.Rkns;
    var $ = Rkns.$ = root.jQuery;
    var _ = Rkns._ = root._;

    Rkns.pickerColors = ["#8f1919", "#a80000", "#d82626", "#ff0000", "#e87c7c", "#ff6565", "#f7d3d3", "#fecccc",
        "#8f5419", "#a85400", "#d87f26", "#ff7f00", "#e8b27c", "#ffb265", "#f7e5d3", "#fee5cc",
        "#8f8f19", "#a8a800", "#d8d826", "#feff00", "#e8e87c", "#feff65", "#f7f7d3", "#fefecc",
        "#198f19", "#00a800", "#26d826", "#00ff00", "#7ce87c", "#65ff65", "#d3f7d3", "#ccfecc",
        "#198f8f", "#00a8a8", "#26d8d8", "#00feff", "#7ce8e8", "#65feff", "#d3f7f7", "#ccfefe",
        "#19198f", "#0000a8", "#2626d8", "#0000ff", "#7c7ce8", "#6565ff", "#d3d3f7", "#ccccfe",
        "#8f198f", "#a800a8", "#d826d8", "#ff00fe", "#e87ce8", "#ff65fe", "#f7d3f7", "#feccfe",
        "#000000", "#242424", "#484848", "#6d6d6d", "#919191", "#b6b6b6", "#dadada", "#ffffff"
    ];

    Rkns.__renkans = [];

    var _BaseBin = Rkns._BaseBin = function(_renkan, _opts) {
        if (typeof _renkan !== "undefined") {
            this.renkan = _renkan;
            this.renkan.$.find(".Rk-Bin-Main").hide();
            this.$ = Rkns.$('<li>')
                .addClass("Rk-Bin")
                .appendTo(_renkan.$.find(".Rk-Bin-List"));
            this.title_icon_$ = Rkns.$('<span>')
                .addClass("Rk-Bin-Title-Icon")
                .appendTo(this.$);

            var _this = this;

            Rkns.$('<a>')
                .attr({
                    href: "#",
                    title: _renkan.translate("Close bin")
                })
                .addClass("Rk-Bin-Close")
                .html('&times;')
                .appendTo(this.$)
                .click(function() {
                    _this.destroy();
                    if (!_renkan.$.find(".Rk-Bin-Main:visible").length) {
                        _renkan.$.find(".Rk-Bin-Main:last").slideDown();
                    }
                    _renkan.resizeBins();
                    return false;
                });
            Rkns.$('<a>')
                .attr({
                    href: "#",
                    title: _renkan.translate("Refresh bin")
                })
                .addClass("Rk-Bin-Refresh")
                .appendTo(this.$)
                .click(function() {
                    _this.refresh();
                    return false;
                });
            this.count_$ = Rkns.$('<div>')
                .addClass("Rk-Bin-Count")
                .appendTo(this.$);
            this.title_$ = Rkns.$('<h2>')
                .addClass("Rk-Bin-Title")
                .appendTo(this.$);
            this.main_$ = Rkns.$('<div>')
                .addClass("Rk-Bin-Main")
                .appendTo(this.$)
                .html('<h4 class="Rk-Bin-Loading">' + _renkan.translate("Loading, please wait") + '</h4>');
            this.title_$.html(_opts.title || '(new bin)');
            this.renkan.resizeBins();

            if (_opts.auto_refresh) {
                window.setInterval(function() {
                    _this.refresh();
                }, _opts.auto_refresh);
            }
        }
    };

    _BaseBin.prototype.destroy = function() {
        this.$.detach();
        this.renkan.resizeBins();
    };

    /* Point of entry */

    var Renkan = Rkns.Renkan = function(_opts) {
        var _this = this;

        Rkns.__renkans.push(this);

        this.options = _.defaults(_opts, Rkns.defaults, {
            templates: _.defaults(_opts.templates, renkanJST) || renkanJST,
            node_editor_templates: _.defaults(_opts.node_editor_templates, Rkns.defaults.node_editor_templates)
        });
        this.template = renkanJST['templates/main.html'];

        var types_templates = {};
        _.each(this.options.node_editor_templates, function(value, key) {
            types_templates[key] = _this.options.templates[value];
            delete _this.options.templates[value];
        });
        this.options.node_editor_templates = types_templates;

        _.each(this.options.property_files, function(f) {
            Rkns.$.getJSON(f, function(data) {
                _this.options.properties = _this.options.properties.concat(data);
            });
        });

        this.read_only = this.options.read_only || !this.options.editor_mode;
        
        this.router = new Rkns.Router();
        
        this.project = new Rkns.Models.Project();
        this.dataloader = new Rkns.DataLoader.Loader(this.project, this.options);

        this.setCurrentUser = function(user_id, user_name) {
            this.project.addUser({
                _id: user_id,
                title: user_name
            });
            this.current_user = user_id;
            this.renderer.redrawUsers();
        };

        if (typeof this.options.user_id !== "undefined") {
            this.current_user = this.options.user_id;
        }
        this.$ = Rkns.$("#" + this.options.container);
        this.$
            .addClass("Rk-Main")
            .html(this.template(this));

        this.tabs = [];
        this.search_engines = [];

        this.current_user_list = new Rkns.Models.UsersList();

        this.current_user_list.on("add remove", function() {
            if (this.renderer) {
                this.renderer.redrawUsers();
            }
        });

        this.colorPicker = (function() {
            var _tmpl = renkanJST['templates/colorpicker.html'];
            return '<ul class="Rk-Edit-ColorPicker">' + Rkns.pickerColors.map(function(c) {
                return _tmpl({
                    c: c
                });
            }).join("") + '</ul>';
        })();

        if (this.options.show_editor) {
            this.renderer = new Rkns.Renderer.Scene(this);
        }

        if (!this.options.search.length) {
            this.$.find(".Rk-Web-Search-Form").detach();
        } else {
            var _tmpl = renkanJST['templates/search.html'],
                _select = this.$.find(".Rk-Search-List"),
                _input = this.$.find(".Rk-Web-Search-Input"),
                _form = this.$.find(".Rk-Web-Search-Form");
            _.each(this.options.search, function(_search, _key) {
                if (Rkns[_search.type] && Rkns[_search.type].Search) {
                    _this.search_engines.push(new Rkns[_search.type].Search(_this, _search));
                }
            });
            _select.html(
                _(this.search_engines).map(function(_search, _key) {
                    return _tmpl({
                        key: _key,
                        title: _search.getSearchTitle(),
                        className: _search.getBgClass()
                    });
                }).join("")
            );
            _select.find("li").click(function() {
                var _el = Rkns.$(this);
                _this.setSearchEngine(_el.attr("data-key"));
                _form.submit();
            });
            _form.submit(function() {
                if (_input.val()) {
                    var _search = _this.search_engine;
                    _search.search(_input.val());
                }
                return false;
            });
            this.$.find(".Rk-Search-Current").mouseenter(
                function() {
                    _select.slideDown();
                }
            );
            this.$.find(".Rk-Search-Select").mouseleave(
                function() {
                    _select.hide();
                }
            );
            this.setSearchEngine(0);
        }
        _.each(this.options.bins, function(_bin) {
            if (Rkns[_bin.type] && Rkns[_bin.type].Bin) {
                _this.tabs.push(new Rkns[_bin.type].Bin(_this, _bin));
            }
        });

        var elementDropped = false;

        this.$.find(".Rk-Bins")
            .on("click", ".Rk-Bin-Title,.Rk-Bin-Title-Icon", function() {
                var _mainDiv = Rkns.$(this).siblings(".Rk-Bin-Main");
                if (_mainDiv.is(":hidden")) {
                    _this.$.find(".Rk-Bin-Main").slideUp();
                    _mainDiv.slideDown();
                }
            });

        if (this.options.show_editor) {

            this.$.find(".Rk-Bins").on("mouseover", ".Rk-Bin-Item", function(_e) {
                var _t = Rkns.$(this);
                if (_t && $(_t).attr("data-uri")) {
                    var _models = _this.project.get("nodes").where({
                        uri: $(_t).attr("data-uri")
                    });
                    _.each(_models, function(_model) {
                        _this.renderer.highlightModel(_model);
                    });
                }
            }).mouseout(function() {
                _this.renderer.unhighlightAll();
            }).on("mousemove", ".Rk-Bin-Item", function(e) {
                try {
                    this.dragDrop();
                } catch (err) {}
            }).on("touchstart", ".Rk-Bin-Item", function(e) {
                elementDropped = false;
            }).on("touchmove", ".Rk-Bin-Item", function(e) {
                e.preventDefault();
                var touch = e.originalEvent.changedTouches[0],
                    off = _this.renderer.canvas_$.offset(),
                    w = _this.renderer.canvas_$.width(),
                    h = _this.renderer.canvas_$.height();
                if (touch.pageX >= off.left && touch.pageX < (off.left + w) && touch.pageY >= off.top && touch.pageY < (off.top + h)) {
                    if (elementDropped) {
                        _this.renderer.onMouseMove(touch, true);
                    } else {
                        elementDropped = true;
                        var div = document.createElement('div');
                        div.appendChild(this.cloneNode(true));
                        _this.renderer.dropData({
                            "text/html": div.innerHTML
                        }, touch);
                        _this.renderer.onMouseDown(touch, true);
                    }
                }
            }).on("touchend", ".Rk-Bin-Item", function(e) {
                if (elementDropped) {
                    _this.renderer.onMouseUp(e.originalEvent.changedTouches[0], true);
                }
                elementDropped = false;
            }).on("dragstart", ".Rk-Bin-Item", function(e) {
                var div = document.createElement('div');
                div.appendChild(this.cloneNode(true));
                try {
                    e.originalEvent.dataTransfer.setData("text/html", div.innerHTML);
                } catch (err) {
                    e.originalEvent.dataTransfer.setData("text", div.innerHTML);
                }
            });

        }

        Rkns.$(window).resize(function() {
            _this.resizeBins();
        });

        var lastsearch = false,
            lastval = '';

        this.$.find(".Rk-Bins-Search-Input").on("change keyup paste input", function() {
            var val = Rkns.$(this).val();
            if (val === lastval) {
                return;
            }
            var search = Rkns.Utils.regexpFromTextOrArray(val.length > 1 ? val : null);
            if (search.source === lastsearch) {
                return;
            }
            lastsearch = search.source;
            _.each(_this.tabs, function(tab) {
                tab.render(search);
            });

        });
        this.$.find(".Rk-Bins-Search-Form").submit(function() {
            return false;
        });
    };

    Renkan.prototype.translate = function(_text) {
        if (Rkns.i18n[this.options.language] && Rkns.i18n[this.options.language][_text]) {
            return Rkns.i18n[this.options.language][_text];
        }
        if (this.options.language.length > 2 && Rkns.i18n[this.options.language.substr(0, 2)] && Rkns.i18n[this.options.language.substr(0, 2)][_text]) {
            return Rkns.i18n[this.options.language.substr(0, 2)][_text];
        }
        return _text;
    };

    Renkan.prototype.onStatusChange = function() {
        this.renderer.onStatusChange();
    };

    Renkan.prototype.setSearchEngine = function(_key) {
        this.search_engine = this.search_engines[_key];
        this.$.find(".Rk-Search-Current").attr("class", "Rk-Search-Current " + this.search_engine.getBgClass());
        var listClasses = this.search_engine.getBgClass().split(" ");
        var classes = "";
        for (var i = 0; i < listClasses.length; i++) {
            classes += "." + listClasses[i];
        }
        this.$.find(".Rk-Web-Search-Input.Rk-Search-Input").attr("placeholder", this.translate("Search in ") + this.$.find(".Rk-Search-List " + classes).html());
    };

    Renkan.prototype.resizeBins = function() {
        var _d = +this.$.find(".Rk-Bins-Head").outerHeight();
        this.$.find(".Rk-Bin-Title:visible").each(function() {
            _d += Rkns.$(this).outerHeight();
        });
        this.$.find(".Rk-Bin-Main").css({
            height: this.$.find(".Rk-Bins").height() - _d
        });
    };

    /* Utility functions */
    var getUUID4 = function() {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
            var r = Math.random() * 16 | 0,
                v = c === 'x' ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        });
    };

    Rkns.Utils = {
        getUUID4: getUUID4,
        getUID: (function() {
            function pad(n) {
                return n < 10 ? '0' + n : n;
            }
            var _d = new Date(),
                ID_AUTO_INCREMENT = 0,
                ID_BASE = _d.getUTCFullYear() + '-' +
                pad(_d.getUTCMonth() + 1) + '-' +
                pad(_d.getUTCDate()) + '-' +
                getUUID4();
            return function(_base) {
                var _n = (++ID_AUTO_INCREMENT).toString(16),
                    _uidbase = (typeof _base === "undefined" ? "" : _base + "-");
                while (_n.length < 4) {
                    _n = '0' + _n;
                }
                return _uidbase + ID_BASE + '-' + _n;
            };
        })(),
        getFullURL: function(url) {

            if (typeof(url) === 'undefined' || url == null) {
                return "";
            }
            if (/https?:\/\//.test(url)) {
                return url;
            }
            var img = new Image();
            img.src = url;
            var res = img.src;
            img.src = null;
            return res;

        },
        inherit: function(_baseClass, _callbefore) {

            var _class = function(_arg) {
                if (typeof _callbefore === "function") {
                    _callbefore.apply(this, Array.prototype.slice.call(arguments, 0));
                }
                _baseClass.apply(this, Array.prototype.slice.call(arguments, 0));
                if (typeof this._init === "function" && !this._initialized) {
                    this._init.apply(this, Array.prototype.slice.call(arguments, 0));
                    this._initialized = true;
                }
            };
            _.extend(_class.prototype, _baseClass.prototype);

            return _class;

        },
        regexpFromTextOrArray: (function() {
            var charsub = [
                    '[aáàâä]',
                    '[cç]',
                    '[eéèêë]',
                    '[iíìîï]',
                    '[oóòôö]',
                    '[uùûü]'
                ],
                removeChars = [
                    String.fromCharCode(768), String.fromCharCode(769), String.fromCharCode(770), String.fromCharCode(771), String.fromCharCode(807),
                    "｛", "｝", "（", "）", "［", "］", "【", "】", "、", "・", "‥", "。", "「", "」", "『", "』", "〜", "：", "！", "？", "　",
                    ",", " ", ";", "(", ")", ".", "*", "+", "\\", "?", "|", "{", "}", "[", "]", "^", "#", "/"
                ],
                remsrc = "[\\" + removeChars.join("\\") + "]",
                remrx = new RegExp(remsrc, "gm"),
                charsrx = _.map(charsub, function(c) {
                    return new RegExp(c);
                });

            function replaceText(_text) {
                var txt = _text.toLowerCase().replace(remrx, ""),
                    src = "";

                function makeReplaceFunc(l) {
                    return function(k, v) {
                        l = l.replace(charsrx[k], v);
                    };
                }
                for (var j = 0; j < txt.length; j++) {
                    if (j) {
                        src += remsrc + "*";
                    }
                    var l = txt[j];
                    _.each(charsub, makeReplaceFunc(l));
                    src += l;
                }
                return src;
            }

            function getSource(inp) {
                switch (typeof inp) {
                    case "string":
                        return replaceText(inp);
                    case "object":
                        var src = '';
                        _.each(inp, function(v) {
                            var res = getSource(v);
                            if (res) {
                                if (src) {
                                    src += '|';
                                }
                                src += res;
                            }
                        });
                        return src;
                }
                return '';
            }

            return function(_textOrArray) {
                var source = getSource(_textOrArray);
                if (source) {
                    var testrx = new RegExp(source, "im"),
                        replacerx = new RegExp('(' + source + ')', "igm");
                    return {
                        isempty: false,
                        source: source,
                        test: function(_t) {
                            return testrx.test(_t);
                        },
                        replace: function(_text, _replace) {
                            return _text.replace(replacerx, _replace);
                        }
                    };
                } else {
                    return {
                        isempty: true,
                        source: '',
                        test: function() {
                            return true;
                        },
                        replace: function(_text) {
                            return text;
                        }
                    };
                }
            };
        })(),
        /* The minimum distance (in pixels) the mouse has to move to consider an element was dragged */
        _MIN_DRAG_DISTANCE: 2,
        /* Distance between the inner and outer radius of buttons that appear when hovering on a node */
        _NODE_BUTTON_WIDTH: 40,

        _EDGE_BUTTON_INNER: 2,
        _EDGE_BUTTON_OUTER: 40,
        /* Constants used to know if a specific action is to be performed when clicking on the canvas */
        _CLICKMODE_ADDNODE: 1,
        _CLICKMODE_STARTEDGE: 2,
        _CLICKMODE_ENDEDGE: 3,
        /* Node size step: Used to calculate the size change when clicking the +/- buttons */
        _NODE_SIZE_STEP: Math.LN2 / 4,
        _MIN_SCALE: 1 / 20,
        _MAX_SCALE: 20,
        _MOUSEMOVE_RATE: 80,
        _DOUBLETAP_DELAY: 800,
        /* Maximum distance in pixels (squared, to reduce calculations)
         * between two taps when double-tapping on a touch terminal */
        _DOUBLETAP_DISTANCE: 20 * 20,
        /* A placeholder so a default colour is displayed when a node has a null value for its user property */
        _USER_PLACEHOLDER: function(_renkan) {
            return {
                color: _renkan.options.default_user_color,
                title: _renkan.translate("(unknown user)"),
                get: function(attr) {
                    return this[attr] || false;
                }
            };
        },
        /* The code for the "Drag and Add Bookmarklet", slightly minified and with whitespaces removed, though
         * it doesn't seem that it's still a requirement in newer browsers (i.e. the ones compatibles with canvas drawing)
         */
        _BOOKMARKLET_CODE: function(_renkan) {
            return "(function(a,b,c,d,e,f,h,i,j,k,l,m,n,o,p,q,r){a=document;b=a.body;c=a.location.href;j='draggable';m='text/x-iri-';d=a.createElement('div');d.innerHTML='<p_style=\"position:fixed;top:0;right:0;font:bold_18px_sans-serif;color:#fff;background:#909;padding:10px;z-index:100000;\">" +
                _renkan.translate("Drag items from this website, drop them in Renkan").replace(/ /g, "_") +
                "</p>'.replace(/_/g,String.fromCharCode(32));b.appendChild(d);e=[{r:/https?:\\/\\/[^\\/]*twitter\\.com\\//,s:'.tweet',n:'twitter'},{r:/https?:\\/\\/[^\\/]*google\\.[^\\/]+\\//,s:'.g',n:'google'},{r:/https?:\\/\\/[^\\/]*lemonde\\.fr\\//,s:'[data-vr-contentbox]',n:'lemonde'}];f=false;e.forEach(function(g){if(g.r.test(c)){f=g;}});if(f){h=function(){Array.prototype.forEach.call(a.querySelectorAll(f.s),function(i){i[j]=true;k=i.style;k.borderWidth='2px';k.borderColor='#909';k.borderStyle='solid';k.backgroundColor='rgba(200,0,180,.1)';})};window.setInterval(h,500);h();};a.addEventListener('dragstart',function(k){l=k.dataTransfer;l.setData(m+'source-uri',c);l.setData(m+'source-title',a.title);n=k.target;if(f){o=n;while(!o.attributes[j]){o=o.parentNode;if(o==b){break;}}}if(f&&o.attributes[j]){p=o.cloneNode(true);l.setData(m+'specific-site',f.n)}else{q=a.getSelection();if(q.type==='Range'||!q.type){p=q.getRangeAt(0).cloneContents();}else{p=n.cloneNode();}}r=a.createElement('div');r.appendChild(p);l.setData('text/x-iri-selected-text',r.textContent.trim());l.setData('text/x-iri-selected-html',r.innerHTML);},false);})();";
        },
        /* Shortens text to the required length then adds ellipsis */
        shortenText: function(_text, _maxlength) {
            return (_text.length > _maxlength ? (_text.substr(0, _maxlength) + '…') : _text);
        },
        /* Drawing an edit box with an arrow and positioning the edit box according to the position of the node/edge being edited
         * Called by Rkns.Renderer.NodeEditor and Rkns.Renderer.EdgeEditor */
        drawEditBox: function(_options, _coords, _path, _xmargin, _selector) {
            _selector.css({
                width: (_options.tooltip_width - 2 * _options.tooltip_padding)
            });
            var _height = _selector.outerHeight() + 2 * _options.tooltip_padding,
                _isLeft = (_coords.x < paper.view.center.x ? 1 : -1),
                _left = _coords.x + _isLeft * (_xmargin + _options.tooltip_arrow_length),
                _right = _coords.x + _isLeft * (_xmargin + _options.tooltip_arrow_length + _options.tooltip_width),
                _top = _coords.y - _height / 2;
            if (_top + _height > (paper.view.size.height - _options.tooltip_margin)) {
                _top = Math.max(paper.view.size.height - _options.tooltip_margin, _coords.y + _options.tooltip_arrow_width / 2) - _height;
            }
            if (_top < _options.tooltip_margin) {
                _top = Math.min(_options.tooltip_margin, _coords.y - _options.tooltip_arrow_width / 2);
            }
            var _bottom = _top + _height;
            /* jshint laxbreak:true */
            _path.segments[0].point = _path.segments[7].point = _coords.add([_isLeft * _xmargin, 0]);
            _path.segments[1].point.x = _path.segments[2].point.x = _path.segments[5].point.x = _path.segments[6].point.x = _left;
            _path.segments[3].point.x = _path.segments[4].point.x = _right;
            _path.segments[2].point.y = _path.segments[3].point.y = _top;
            _path.segments[4].point.y = _path.segments[5].point.y = _bottom;
            _path.segments[1].point.y = _coords.y - _options.tooltip_arrow_width / 2;
            _path.segments[6].point.y = _coords.y + _options.tooltip_arrow_width / 2;
            _path.closed = true;
            _path.fillColor = new paper.GradientColor(new paper.Gradient([_options.tooltip_top_color, _options.tooltip_bottom_color]), [0, _top], [0, _bottom]);
            _selector.css({
                left: (_options.tooltip_padding + Math.min(_left, _right)),
                top: (_options.tooltip_padding + _top)
            });
            return _path;
        },
        // from http://stackoverflow.com/a/6444043
        increaseBrightness: function (hex, percent){
            // strip the leading # if it's there
            hex = hex.replace(/^\s*#|\s*$/g, '');

            // convert 3 char codes --> 6, e.g. `E0F` --> `EE00FF`
            if(hex.length === 3){
                hex = hex.replace(/(.)/g, '$1$1');
            }

            var r = parseInt(hex.substr(0, 2), 16),
                g = parseInt(hex.substr(2, 2), 16),
                b = parseInt(hex.substr(4, 2), 16);

            return '#' +
               ((0|(1<<8) + r + (256 - r) * percent / 100).toString(16)).substr(1) +
               ((0|(1<<8) + g + (256 - g) * percent / 100).toString(16)).substr(1) +
               ((0|(1<<8) + b + (256 - b) * percent / 100).toString(16)).substr(1);
        }
    };
})(window);

/* END main.js */

(function(root) {
    "use strict";
    
    var Backbone = root.Backbone;
    
    var Router = root.Rkns.Router = Backbone.Router.extend({
        routes: {
            '': 'index'
        },
        
        index: function (parameters) {
            
            var result = {};
            if (parameters === null){
                return;
            }
            parameters.split("&").forEach(function(part) {
              var item = part.split("=");
              result[item[0]] = decodeURIComponent(item[1]);
            });
            this.trigger('router', result);            
        }  
    });

})(window);
(function(root) {

    "use strict";

    var DataLoader = root.Rkns.DataLoader = {
        converters: {
            from1to2: function(data) {

                var i, len;
                if(typeof data.nodes !== 'undefined') {
                    for(i=0, len=data.nodes.length; i<len; i++) {
                        var node = data.nodes[i];
                        if(node.color) {
                            node.style = {
                                color: node.color,
                            };
                        }
                        else {
                            node.style = {};
                        }
                    }
                }
                if(typeof data.edges !== 'undefined') {
                    for(i=0, len=data.edges.length; i<len; i++) {
                        var edge = data.edges[i];
                        if(edge.color) {
                            edge.style = {
                                color: edge.color,
                            };
                        }
                        else {
                            edge.style = {};
                        }
                    }
                }

                data.schema_version = "2";

                return data;
            },
        }
    };


    DataLoader.Loader = function(project, options) {
        this.project = project;
        this.dataConverters = _.defaults(options.converters || {}, DataLoader.converters);
    };


    DataLoader.Loader.prototype.convert = function(data) {
        var schemaVersionFrom = this.project.getSchemaVersion(data);
        var schemaVersionTo = this.project.getSchemaVersion();

        if (schemaVersionFrom !== schemaVersionTo) {
            var converterName = "from" + schemaVersionFrom + "to" + schemaVersionTo;
            if (typeof this.dataConverters[converterName] === 'function') {
                data = this.dataConverters[converterName](data);
            }
        }
        return data;
    };

    DataLoader.Loader.prototype.load = function(data) {
        this.project.set(this.convert(data), {
            validate: true
        });
    };

})(window);

(function(root) {
    "use strict";

    var Backbone = root.Backbone;

    var Models = root.Rkns.Models = {};

    Models.getUID = function(obj) {
        var guid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,
                function(c) {
                    var r = Math.random() * 16 | 0, v = c === 'x' ? r
                            : (r & 0x3 | 0x8);
                    return v.toString(16);
                });
        if (typeof obj !== 'undefined') {
            return obj.type + "-" + guid;
        }
        else {
            return guid;
        }
    };

    var RenkanModel = Backbone.RelationalModel.extend({
        idAttribute : "_id",
        constructor : function(options) {

            if (typeof options !== "undefined") {
                options._id = options._id || options.id || Models.getUID(this);
                options.title = options.title || "";
                options.description = options.description || "";
                options.uri = options.uri || "";

                if (typeof this.prepare === "function") {
                    options = this.prepare(options);
                }
            }
            Backbone.RelationalModel.prototype.constructor.call(this, options);
        },
        validate : function() {
            if (!this.type) {
                return "object has no type";
            }
        },
        addReference : function(_options, _propName, _list, _id, _default) {
            var _element = _list.get(_id);
            if (typeof _element === "undefined" &&
                typeof _default !== "undefined") {
                _options[_propName] = _default;
            }
            else {
                _options[_propName] = _element;
            }
        }
    });

    // USER
    var User = Models.User = RenkanModel.extend({
        type : "user",
        prepare : function(options) {
            options.color = options.color || "#666666";
            return options;
        },
        toJSON : function() {
            return {
                _id : this.get("_id"),
                title : this.get("title"),
                uri : this.get("uri"),
                description : this.get("description"),
                color : this.get("color")
            };
        }
    });

    // NODE
    var Node = Models.Node = RenkanModel.extend({
        type : "node",
        relations : [ {
            type : Backbone.HasOne,
            key : "created_by",
            relatedModel : User
        } ],
        prepare : function(options) {
            var project = options.project;
            this.addReference(options, "created_by", project.get("users"),
                    options.created_by, project.current_user);
            options.description = options.description || "";
            return options;
        },
        toJSON : function() {
            return {
                _id : this.get("_id"),
                title : this.get("title"),
                uri : this.get("uri"),
                description : this.get("description"),
                position : this.get("position"),
                image : this.get("image"),
                style : this.get("style"),
                created_by : this.get("created_by") ? this.get("created_by")
                        .get("_id") : null,
                size : this.get("size"),
                clip_path : this.get("clip_path"),
                shape : this.get("shape"),  
                type : this.get("type")
            };
        }
    });

    // EDGE
    var Edge = Models.Edge = RenkanModel.extend({
        type : "edge",
        relations : [ {
            type : Backbone.HasOne,
            key : "created_by",
            relatedModel : User
        }, {
            type : Backbone.HasOne,
            key : "from",
            relatedModel : Node
        }, {
            type : Backbone.HasOne,
            key : "to",
            relatedModel : Node
        } ],
        prepare : function(options) {
            var project = options.project;
            this.addReference(options, "created_by", project.get("users"),
                    options.created_by, project.current_user);
            this.addReference(options, "from", project.get("nodes"),
                    options.from);
            this.addReference(options, "to", project.get("nodes"), options.to);
            return options;
        },
        toJSON : function() {
            return {
                _id : this.get("_id"),
                title : this.get("title"),
                uri : this.get("uri"),
                description : this.get("description"),
                from : this.get("from") ? this.get("from").get("_id") : null,
                to : this.get("to") ? this.get("to").get("_id") : null,
                style : this.get("style"),
                created_by : this.get("created_by") ? this.get("created_by")
                        .get("_id") : null
            };
        }
    });

    // View
    var View = Models.View = RenkanModel.extend({
        type : "view",
        relations : [ {
            type : Backbone.HasOne,
            key : "created_by",
            relatedModel : User
        } ],
        prepare : function(options) {
            var project = options.project;
            this.addReference(options, "created_by", project.get("users"),
                    options.created_by, project.current_user);
            options.description = options.description || "";
            if (typeof options.offset !== "undefined") {
                var offset = {};
                if (Array.isArray(options.offset)) {
                    offset.x = options.offset[0];
                    offset.y = options.offset.length > 1 ? options.offset[1]
                            : options.offset[0];
                }
                else if (options.offset.x != null) {
                    offset.x = options.offset.x;
                    offset.y = options.offset.y;
                }
                options.offset = offset;
            }
            return options;
        },
        toJSON : function() {
            return {
                _id : this.get("_id"),
                zoom_level : this.get("zoom_level"),
                offset : this.get("offset"),
                title : this.get("title"),
                description : this.get("description"),
                created_by : this.get("created_by") ? this.get("created_by")
                        .get("_id") : null,
                hidden_nodes: this.get("hidden_nodes")
            // Don't need project id
            };
        }
    });

    // PROJECT
    var Project = Models.Project = RenkanModel.extend({
        schema_version : "2",
        type : "project",
        blacklist : [ 'saveStatus', 'loadingStatus'],
        relations : [ {
            type : Backbone.HasMany,
            key : "users",
            relatedModel : User,
            reverseRelation : {
                key : 'project',
                includeInJSON : '_id'
            }
        }, {
            type : Backbone.HasMany,
            key : "nodes",
            relatedModel : Node,
            reverseRelation : {
                key : 'project',
                includeInJSON : '_id'
            }
        }, {
            type : Backbone.HasMany,
            key : "edges",
            relatedModel : Edge,
            reverseRelation : {
                key : 'project',
                includeInJSON : '_id'
            }
        }, {
            type : Backbone.HasMany,
            key : "views",
            relatedModel : View,
            reverseRelation : {
                key : 'project',
                includeInJSON : '_id'
            }
        } ],
        addUser : function(_props, _options) {
            _props.project = this;
            var _user = User.findOrCreate(_props);
            this.get("users").push(_user, _options);
            return _user;
        },
        addNode : function(_props, _options) {
            _props.project = this;
            var _node = Node.findOrCreate(_props);
            this.get("nodes").push(_node, _options);
            return _node;
        },
        addEdge : function(_props, _options) {
            _props.project = this;
            var _edge = Edge.findOrCreate(_props);
            this.get("edges").push(_edge, _options);
            return _edge;
        },
        addView : function(_props, _options) {
            _props.project = this;
            // TODO: check if need to replace with create only
            var _view = View.findOrCreate(_props);
            // TODO: Should we remember only one view?
            this.get("views").push(_view, _options);
            return _view;
        },
        removeNode : function(_model) {
            this.get("nodes").remove(_model);
        },
        removeEdge : function(_model) {
            this.get("edges").remove(_model);
        },
        validate : function(options) {
            var _project = this;
            _.each(
              [].concat(options.users, options.nodes, options.edges,options.views),
              function(_item) {
                if (_item) {
                    _item.project = _project;
                }
              }
            );
        },
        getSchemaVersion : function(data) {
          var t = data;
          if(typeof(t) === "undefined") {
            t = this;
          }
          var version = t.schema_version;
          if(!version) {
            return 1;
          }
          else {
            return version;
          }
        },
        // Add event handler to remove edges when a node is removed
        initialize : function() {
            var _this = this;
            this.on("remove:nodes", function(_node) {
                _this.get("edges").remove(
                        _this.get("edges").filter(
                                function(_edge) {
                                    return _edge.get("from") === _node ||
                                           _edge.get("to") === _node;
                                }));
            });
        },
        toJSON : function() {
            var json = _.clone(this.attributes);
            for ( var attr in json) {
                if ((json[attr] instanceof Backbone.Model) ||
                        (json[attr] instanceof Backbone.Collection) ||
                        (json[attr] instanceof RenkanModel)) {
                    json[attr] = json[attr].toJSON();
                }
            }
            return _.omit(json, this.blacklist);
        }
    });

    var RosterUser = Models.RosterUser = Backbone.Model
            .extend({
                type : "roster_user",
                idAttribute : "_id",

                constructor : function(options) {

                    if (typeof options !== "undefined") {
                        options._id = options._id ||
                            options.id ||
                            Models.getUID(this);
                        options.title = options.title || "(untitled " + this.type + ")";
                        options.description = options.description || "";
                        options.uri = options.uri || "";
                        options.project = options.project || null;
                        options.site_id = options.site_id || 0;

                        if (typeof this.prepare === "function") {
                            options = this.prepare(options);
                        }
                    }
                    Backbone.Model.prototype.constructor.call(this, options);
                },

                validate : function() {
                    if (!this.type) {
                        return "object has no type";
                    }
                },

                prepare : function(options) {
                    options.color = options.color || "#666666";
                    return options;
                },

                toJSON : function() {
                    return {
                        _id : this.get("_id"),
                        title : this.get("title"),
                        uri : this.get("uri"),
                        description : this.get("description"),
                        color : this.get("color"),
                        project : (this.get("project") != null) ? this.get(
                                "project").get("id") : null,
                        site_id : this.get("site_id")
                    };
                }
            });

    var UsersList = Models.UsersList = Backbone.Collection.extend({
        model : RosterUser
    });

})(window);

Rkns.defaults = {

    language: (navigator.language || navigator.userLanguage || "en"),
        /* GUI Language */
    container: "renkan",
        /* GUI Container DOM element ID */
    search: [],
        /* List of Search Engines */
    bins: [],
           /* List of Bins */
    static_url: "",
        /* URL for static resources */
    popup_editor: true,
        /* show the node editor as a popup inside the renkan view */
    editor_panel: 'editor-panel',
        /* GUI continer DOM element ID of the editor panel */
    show_bins: true,
        /* Show bins in left column */
    properties: [],
        /* Semantic properties for edges */
    show_editor: true,
        /* Show the graph editor... Setting this to "false" only shows the bins part ! */
    read_only: false,
        /* Allows editing of renkan without changing the rest of the GUI. Can be switched on/off on the fly to block/enable editing */
    editor_mode: true,
        /* Switch for Publish/Edit GUI. If editor_mode is false, read_only will be true.  */
    manual_save: false,
        /* In snapshot mode, clicking on the floppy will save a snapshot. Otherwise, it will show the connection status */
    show_top_bar: true,
        /* Show the top bar, (title, buttons, users) */
    default_user_color: "#303030",
    size_bug_fix: true,
        /* Resize the canvas after load (fixes a bug on iPad and FF Mac) */
    force_resize: false,
    allow_double_click: true,
        /* Allows Double Click to create a node on an empty background */
    zoom_on_scroll: true,
        /* Allows to use the scrollwheel to zoom */
    element_delete_delay: 0,
        /* Delay between clicking on the bin on an element and really deleting it
           Set to 0 for delete confirm */
    autoscale_padding: 50,
    resize: true,

    /* zoom options */
    show_zoom: true,
        /* show zoom buttons */
    save_view: true,
        /* show buttons to save view */
    default_view: false,
        /* Allows to load default view (zoom+offset) at start on read_only mode, instead of autoScale. the default_view will be the last */


    /* TOP BAR BUTTONS */
    show_search_field: true,
    show_user_list: true,
    user_name_editable: true,
    user_color_editable: true,
    show_user_color: true,
    show_save_button: true,
    show_export_button: true,
    show_open_button: false,
    show_addnode_button: true,
    show_addedge_button: true,
    show_bookmarklet: true,
    show_fullscreen_button: true,
    home_button_url: false,
    home_button_title: "Home",

    /* MINI-MAP OPTIONS */

    show_minimap: true,
        /* Show a small map at the bottom right */
    minimap_width: 160,
    minimap_height: 120,
    minimap_padding: 20,
    minimap_background_color: "#ffffff",
    minimap_border_color: "#cccccc",
    minimap_highlight_color: "#ffff00",
    minimap_highlight_weight: 5,


    /* EDGE/NODE COMMON OPTIONS */

    buttons_background: "#202020",
    buttons_label_color: "#c000c0",
    buttons_label_font_size: 9,

    ghost_opacity : 0.3,
        /* opacity when the hidden element is revealed */
    default_dash_array : [4, 5],
        /* dash line genometry */

    /* NODE DISPLAY OPTIONS */

    show_node_circles: true,
        /* Show circles for nodes */
    clip_node_images: true,
        /* Constraint node images to circles */
    node_images_fill_mode: false,
        /* Set to false for "letterboxing" (height/width of node adapted to show full image)
           Set to true for "crop" (adapted to fill circle) */
    node_size_base: 25,
    node_stroke_width: 2,
    node_stroke_max_width: 12,
    selected_node_stroke_width: 4,
    selected_node_stroke_max_width: 24,
    node_stroke_witdh_scale: 5,
    node_fill_color: "#ffffff",
    highlighted_node_fill_color: "#ffff00",
    node_label_distance: 5,
        /* Vertical distance between node and label */
    node_label_max_length: 60,
        /* Maximum displayed text length */
    label_untitled_nodes: "(untitled)",
        /* Label to display on untitled nodes */
    hide_nodes: true, 
        /* allow hide/show nodes */
    change_shapes: true,
        /* Change shapes enabled */
    change_types: true,
    /* Change type enabled */
    
    /* NODE EDITOR TEMPLATE*/
    
    node_editor_templates: {
        "default": "templates/nodeeditor_readonly.html",
        "video": "templates/nodeeditor_video.html"
    },

    /* EDGE DISPLAY OPTIONS */

    edge_stroke_width: 2,
    edge_stroke_max_width: 12,
    selected_edge_stroke_width: 4,
    selected_edge_stroke_max_width: 24,
    edge_stroke_witdh_scale: 5,

    edge_label_distance: 0,
    edge_label_max_length: 20,
    edge_arrow_length: 18,
    edge_arrow_width: 12,
    edge_arrow_max_width: 32,
    edge_gap_in_bundles: 12,
    label_untitled_edges: "",

    /* CONTEXTUAL DISPLAY (TOOLTIP OR EDITOR) OPTIONS */

    tooltip_width: 275,
    tooltip_padding: 10,
    tooltip_margin: 15,
    tooltip_arrow_length : 20,
    tooltip_arrow_width : 40,
    tooltip_top_color: "#f0f0f0",
    tooltip_bottom_color: "#d0d0d0",
    tooltip_border_color: "#808080",
    tooltip_border_width: 1,

    richtext_editor_config: {
        toolbarGroups: [
            { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
            { name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
            '/',
	        { name: 'styles'},
        ],
        removePlugins : 'colorbutton,find,flash,font,forms,iframe,image,newpage,smiley,specialchar,stylescombo,templates',
    },

    /* NODE EDITOR OPTIONS */

    show_node_editor_uri: true,
    show_node_editor_description: true,
    show_node_editor_description_richtext: true,
    show_node_editor_size: true,
    show_node_editor_style: true,
    show_node_editor_style_color: true,
    show_node_editor_style_dash: true,
    show_node_editor_style_thickness: true,
    show_node_editor_image: true,
    show_node_editor_creator: true,
    allow_image_upload: true,
    uploaded_image_max_kb: 500,


    /* NODE TOOLTIP OPTIONS */

    show_node_tooltip_uri: true,
    show_node_tooltip_description: true,
    show_node_tooltip_color: true,
    show_node_tooltip_image: true,
    show_node_tooltip_creator: true,

    /* EDGE EDITOR OPTIONS */

    show_edge_editor_uri: true,
    show_edge_editor_style: true,
    show_edge_editor_style_color: true,
    show_edge_editor_style_dash: true,
    show_edge_editor_style_thickness: true,
    show_edge_editor_style_arrow: true,
    show_edge_editor_direction: true,
    show_edge_editor_nodes: true,
    show_edge_editor_creator: true,

    /* EDGE TOOLTIP OPTIONS */

    show_edge_tooltip_uri: true,
    show_edge_tooltip_color: true,
    show_edge_tooltip_nodes: true,
    show_edge_tooltip_creator: true,

};

Rkns.i18n = {
    fr: {
        "Edit Node": "Édition d’un nœud",
        "Edit Edge": "Édition d’un lien",
        "Title:": "Titre :",
        "URI:": "URI :",
        "Description:": "Description :",
        "From:": "De :",
        "To:": "Vers :",
        "Image": "Image",
        "Image URL:": "URL d'Image",
        "Choose Image File:": "Choisir un fichier image",
        "Full Screen": "Mode plein écran",
        "Add Node": "Ajouter un nœud",
        "Add Edge": "Ajouter un lien",
        "Save Project": "Enregistrer le projet",
        "Open Project": "Ouvrir un projet",
        "Auto-save enabled": "Enregistrement automatique activé",
        "Connection lost": "Connexion perdue",
        "Created by:": "Créé par :",
        "Zoom In": "Agrandir l’échelle",
        "Zoom Out": "Rapetisser l’échelle",
        "Edit": "Éditer",
        "Remove": "Supprimer",
        "Cancel deletion": "Annuler la suppression",
        "Link to another node": "Créer un lien",
        "Enlarge": "Agrandir",
        "Shrink": "Rétrécir",
        "Click on the background canvas to add a node": "Cliquer sur le fond du graphe pour rajouter un nœud",
        "Click on a first node to start the edge": "Cliquer sur un premier nœud pour commencer le lien",
        "Click on a second node to complete the edge": "Cliquer sur un second nœud pour terminer le lien",
        "Wikipedia": "Wikipédia",
        "Wikipedia in ": "Wikipédia en ",
        "French": "Français",
        "English": "Anglais",
        "Japanese": "Japonais",
        "Untitled project": "Projet sans titre",
        "Lignes de Temps": "Lignes de Temps",
        "Loading, please wait": "Chargement en cours, merci de patienter",
        "Edge color:": "Couleur :",
        "Dash:": "Point. :",
        "Thickness:": "Epaisseur :",
        "Arrow:": "Flèche :",
        "Node color:": "Couleur :",
        "Choose color": "Choisir une couleur",
        "Change edge direction": "Changer le sens du lien",
        "Do you really wish to remove node ": "Voulez-vous réellement supprimer le nœud ",
        "Do you really wish to remove edge ": "Voulez-vous réellement supprimer le lien ",
        "This file is not an image": "Ce fichier n'est pas une image",
        "Image size must be under ": "L'image doit peser moins de ",
        "Size:": "Taille :",
        "KB": "ko",
        "Choose from vocabulary:": "Choisir dans un vocabulaire :",
        "SKOS Documentation properties": "SKOS: Propriétés documentaires",
        "has note": "a pour note",
        "has example": "a pour exemple",
        "has definition": "a pour définition",
        "SKOS Semantic relations": "SKOS: Relations sémantiques",
        "has broader": "a pour concept plus large",
        "has narrower": "a pour concept plus étroit",
        "has related": "a pour concept apparenté",
        "Dublin Core Metadata": "Métadonnées Dublin Core",
        "has contributor": "a pour contributeur",
        "covers": "couvre",
        "created by": "créé par",
        "has date": "a pour date",
        "published by": "édité par",
        "has source": "a pour source",
        "has subject": "a pour sujet",
        "Dragged resource": "Ressource glisée-déposée",
        "Search the Web": "Rechercher en ligne",
        "Search in Bins": "Rechercher dans les chutiers",
        "Close bin": "Fermer le chutier",
        "Refresh bin": "Rafraîchir le chutier",
        "(untitled)": "(sans titre)",
        "Select contents:": "Sélectionner des contenus :",
        "Drag items from this website, drop them in Renkan": "Glissez des éléments de ce site web vers Renkan",
        "Drag this button to your bookmark bar. When on a third-party website, click it to enable drag-and-drop from the website to Renkan.": "Glissez ce bouton vers votre barre de favoris. Ensuite, depuis un site tiers, cliquez dessus pour activer 'Drag-to-Add' puis glissez des éléments de ce site vers Renkan",
        "Shapes available": "Formes disponibles",
        "Circle": "Cercle",
        "Square": "Carré",
        "Diamond": "Losange",
        "Hexagone": "Hexagone",
        "Ellipse": "Ellipse",
        "Star": "Étoile",
        "Cloud": "Nuage",
        "Triangle": "Triangle",
        "Zoom Fit": "Ajuster le Zoom",
        "Download Project": "Télécharger le projet",
        "Save view": "Sauver la vue",
        "View saved view": "Restaurer la Vue",
        "Renkan \'Drag-to-Add\' bookmarklet": "Renkan \'Deplacer-Pour-Ajouter\' Signet",
        "(unknown user)":"(non authentifié)",
        "<unknown user>":"<non authentifié>",
        "Search in graph":"Rechercher dans carte",
        "Search in " : "Chercher dans "
    }
};

/* Saves the Full JSON at each modification */

Rkns.jsonIO = function(_renkan, _opts) {
    var _proj = _renkan.project;
    if (typeof _opts.http_method === "undefined") {
        _opts.http_method = 'PUT';
    }
    var _load = function() {
        _renkan.renderer.redrawActive = false;
        _proj.set({
            loadingStatus : true
        });
        Rkns.$.getJSON(_opts.url, function(_data) {
            _renkan.dataloader.load(_data);
            _proj.set({
                loadingStatus : false
            });
            _proj.set({
                saveStatus : 0
            });
            _renkan.renderer.redrawActive = true;
            _renkan.renderer.fixSize();
        });
    };
    var _save = function() {
        _proj.set({
            saveStatus : 2
        });
        var _data = _proj.toJSON();
        if (!_renkan.read_only) {
            Rkns.$.ajax({
                type : _opts.http_method,
                url : _opts.url,
                contentType : "application/json",
                data : JSON.stringify(_data),
                success : function(data, textStatus, jqXHR) {
                    _proj.set({
                        saveStatus : 0
                    });
                }
            });
        }

    };
    var _thrSave = Rkns._.throttle(function() {
        setTimeout(_save, 100);
    }, 1000);
    _proj.on("add:nodes add:edges add:users add:views", function(_model) {
        _model.on("change remove", function(_model) {
            _thrSave();
        });
        _thrSave();
    });
    _proj.on("change", function() {
        if (!(_proj.changedAttributes.length === 1 && _proj
                .hasChanged('saveStatus'))) {
            _thrSave();
        }
    });

    _load();
};

/* Saves the Full JSON once */

Rkns.jsonIOSaveOnClick = function(_renkan, _opts) {
    var _proj = _renkan.project,
        _saveWarn = false,
        _onLeave = function() {
            return "Project not saved";
        };
    if (typeof _opts.http_method === "undefined") {
        _opts.http_method = 'POST';
    }
    var _load = function() {
        var getdata = {},
            rx = /id=([^&#?=]+)/,
            matches = document.location.hash.match(rx);
        if (matches) {
            getdata.id = matches[1];
        }
        Rkns.$.ajax({
            url: _opts.url,
            data: getdata,
            beforeSend: function(){
            	_proj.set({loadingStatus:true});
            },
            success: function(_data) {
                _renkan.dataloader.load(_data);
                _proj.set({loadingStatus:false});
                _proj.set({saveStatus:0});
                _renkan.renderer.autoScale();
            }
        });
    };
    var _save = function() {
        _proj.set("saved_at", new Date());
        var _data = _proj.toJSON();
        Rkns.$.ajax({
            type: _opts.http_method,
            url: _opts.url,
            contentType: "application/json",
            data: JSON.stringify(_data),
            beforeSend: function(){
            	_proj.set({saveStatus:2});
            },
            success: function(data, textStatus, jqXHR) {
                $(window).off("beforeunload", _onLeave);
                _saveWarn = false;
                _proj.set({saveStatus:0});
                //document.location.hash = "#id=" + data.id;
                //$(".Rk-Notifications").text("Saved as "+document.location.href).fadeIn().delay(2000).fadeOut();
            }
        });
    };
    var _checkLeave = function() {
    	_proj.set({saveStatus:1});

        var title = _proj.get("title");
        if (title && _proj.get("nodes").length) {
            $(".Rk-Save-Button").removeClass("disabled");
        } else {
            $(".Rk-Save-Button").addClass("disabled");
        }
        if (title) {
            $(".Rk-PadTitle").css("border-color","#333333");
        }
        if (!_saveWarn) {
            _saveWarn = true;
            $(window).on("beforeunload", _onLeave);
        }
    };
    _load();
    _proj.on("add:nodes add:edges add:users change", function(_model) {
	    _model.on("change remove", function(_model) {
	    	if(!(_model.changedAttributes.length === 1 && _model.hasChanged('saveStatus'))) {
	    		_checkLeave();
	    	}
	    });
		if(!(_proj.changedAttributes.length === 1 && _proj.hasChanged('saveStatus'))) {
		    _checkLeave();
    	}
    });
    _renkan.renderer.save = function() {
        if ($(".Rk-Save-Button").hasClass("disabled")) {
            if (!_proj.get("title")) {
                $(".Rk-PadTitle").css("border-color","#ff0000");
            }
        } else {
            _save();
        }
    };
};

(function(Rkns) {
"use strict";

var _ = Rkns._;

var Ldt = Rkns.Ldt = {};

var Bin = Ldt.Bin = function(_renkan, _opts) {
    if (_opts.ldt_type) {
        var Resclass = Ldt[_opts.ldt_type+"Bin"];
        if (Resclass) {
            return new Resclass(_renkan, _opts);
        }
    }
    console.error("No such LDT Bin Type");
};

var ProjectBin = Ldt.ProjectBin = Rkns.Utils.inherit(Rkns._BaseBin);

ProjectBin.prototype.tagTemplate = renkanJST['templates/ldtjson-bin/tagtemplate.html'];

ProjectBin.prototype.annotationTemplate = renkanJST['templates/ldtjson-bin/annotationtemplate.html'];

ProjectBin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.proj_id = _opts.project_id;
    this.ldt_platform = _opts.ldt_platform || "http://ldt.iri.centrepompidou.fr/";
    this.title_$.html(_opts.title);
    this.title_icon_$.addClass('Rk-Ldt-Title-Icon');
    this.refresh();
};

ProjectBin.prototype.render = function(searchbase) {
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    function highlight(_text) {
        var _e = _(_text).escape();
        return search.isempty ? _e : search.replace(_e, "<span class='searchmatch'>$1</span>");
    }
    function convertTC(_ms) {
        function pad(_n) {
            var _res = _n.toString();
            while (_res.length < 2) {
                _res = '0' + _res;
            }
            return _res;
        }
        var _totalSeconds = Math.abs(Math.floor(_ms/1000)),
            _hours = Math.floor(_totalSeconds / 3600),
            _minutes = (Math.floor(_totalSeconds / 60) % 60),
            _seconds = _totalSeconds % 60,
            _res = '';
        if (_hours) {
            _res += pad(_hours) + ':';
        }
        _res += pad(_minutes) + ':' + pad(_seconds);
        return _res;
    }

    var _html = '<li><h3>Tags</h3></li>',
        _projtitle = this.data.meta["dc:title"],
        _this = this,
        count = 0;
    _this.title_$.text('LDT Project: "' + _projtitle + '"');
    _.map(_this.data.tags,function(_tag) {
        var _title = _tag.meta["dc:title"];
        if (!search.isempty && !search.test(_title)) {
            return;
        }
        count++;
        _html += _this.tagTemplate({
            ldt_platform: _this.ldt_platform,
            title: _title,
            htitle: highlight(_title),
            encodedtitle : encodeURIComponent(_title),
            static_url: _this.renkan.options.static_url
        });
    });
    _html += '<li><h3>Annotations</h3></li>';
    _.map(_this.data.annotations,function(_annotation) {
        var _description = _annotation.content.description,
            _title = _annotation.content.title.replace(_description,"");
        if (!search.isempty && !search.test(_title) && !search.test(_description)) {
            return;
        }
        count++;
        var _duration = _annotation.end - _annotation.begin,
            _img = (
                (_annotation.content && _annotation.content.img && _annotation.content.img.src) ?
                  _annotation.content.img.src :
                  ( _duration ? _this.renkan.options.static_url+"img/ldt-segment.png" : _this.renkan.options.static_url+"img/ldt-point.png" )
            );
        _html += _this.annotationTemplate({
            ldt_platform: _this.ldt_platform,
            title: _title,
            htitle: highlight(_title),
            description: _description,
            hdescription: highlight(_description),
            start: convertTC(_annotation.begin),
            end: convertTC(_annotation.end),
            duration: convertTC(_duration),
            mediaid: _annotation.media,
            annotationid: _annotation.id,
            image: _img,
            static_url: _this.renkan.options.static_url
        });
    });

    this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

ProjectBin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: this.ldt_platform + 'ldtplatform/ldt/cljson/id/' + this.proj_id,
        dataType: "jsonp",
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
};

var Search = Ldt.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "en";
};

Search.prototype.getBgClass = function() {
    return "Rk-Ldt-Icon";
};

Search.prototype.getSearchTitle = function() {
    return this.renkan.translate("Lignes de Temps");
};

Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new ResultsBin(this.renkan, {
            search: _q
        })
    );
};

var ResultsBin = Ldt.ResultsBin = Rkns.Utils.inherit(Rkns._BaseBin);

ResultsBin.prototype.segmentTemplate = renkanJST['templates/ldtjson-bin/segmenttemplate.html'];

ResultsBin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.ldt_platform = _opts.ldt_platform || "http://ldt.iri.centrepompidou.fr/";
    this.max_results = _opts.max_results || 50;
    this.search = _opts.search;
    this.title_$.html('Lignes de Temps: "' + _opts.search + '"');
    this.title_icon_$.addClass('Rk-Ldt-Title-Icon');
    this.refresh();
};

ResultsBin.prototype.render = function(searchbase) {
    if (!this.data) {
        return;
    }
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    var highlightrx = (search.isempty ? Rkns.Utils.regexpFromTextOrArray(this.search) : search);
    function highlight(_text) {
        return highlightrx.replace(_(_text).escape(), "<span class='searchmatch'>$1</span>");
    }
    function convertTC(_ms) {
        function pad(_n) {
            var _res = _n.toString();
            while (_res.length < 2) {
                _res = '0' + _res;
            }
            return _res;
        }
        var _totalSeconds = Math.abs(Math.floor(_ms/1000)),
            _hours = Math.floor(_totalSeconds / 3600),
            _minutes = (Math.floor(_totalSeconds / 60) % 60),
            _seconds = _totalSeconds % 60,
            _res = '';
        if (_hours) {
            _res += pad(_hours) + ':';
        }
        _res += pad(_minutes) + ':' + pad(_seconds);
        return _res;
    }

    var _html = '',
        _this = this,
        count = 0;
    _.each(this.data.objects,function(_segment) {
        var _description = _segment.abstract,
            _title = _segment.title;
        if (!search.isempty && !search.test(_title) && !search.test(_description)) {
            return;
        }
        count++;
        var _duration = _segment.duration,
            _begin = _segment.start_ts,
            _end = + _segment.duration + _begin,
            _img = (
                _duration ?
                  _this.renkan.options.static_url + "img/ldt-segment.png" :
                  _this.renkan.options.static_url + "img/ldt-point.png"
            );
        _html += _this.segmentTemplate({
            ldt_platform: _this.ldt_platform,
            title: _title,
            htitle: highlight(_title),
            description: _description,
            hdescription: highlight(_description),
            start: convertTC(_begin),
            end: convertTC(_end),
            duration: convertTC(_duration),
            mediaid: _segment.iri_id,
            //projectid: _segment.project_id,
            //cuttingid: _segment.cutting_id,
            annotationid: _segment.element_id,
            image: _img
        });
    });

    this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

ResultsBin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: this.ldt_platform + 'ldtplatform/api/ldt/1.0/segments/search/',
        data: {
            format: "jsonp",
            q: this.search,
            limit: this.max_results
        },
        dataType: "jsonp",
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
};

})(window.Rkns);

Rkns.ResourceList = {};

Rkns.ResourceList.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.ResourceList.Bin.prototype.resultTemplate = renkanJST['templates/list-bin.html'];

Rkns.ResourceList.Bin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.title_$.html(_opts.title);
    if (_opts.list) {
        this.data = _opts.list;
    }
    this.refresh();
};

Rkns.ResourceList.Bin.prototype.render = function(searchbase) {
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    function highlight(_text) {
        var _e = _(_text).escape();
        return search.isempty ? _e : search.replace(_e, "<span class='searchmatch'>$1</span>");
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._.each(this.data,function(_item) {
        var _element;
        if (typeof _item === "string") {
            if (/^(https?:\/\/|www)/.test(_item)) {
                _element = { url: _item };
            } else {
                _element = { title: _item.replace(/[:,]?\s?(https?:\/\/|www)[\d\w\/.&?=#%-_]+\s?/,'').trim() };
                var _match = _item.match(/(https?:\/\/|www)[\d\w\/.&?=#%-_]+/);
                if (_match) {
                    _element.url = _match[0];
                }
                if (_element.title.length > 80) {
                    _element.description = _element.title;
                    _element.title = _element.title.replace(/^(.{30,60})\s.+$/,'$1…');
                }
            }
        } else {
            _element = _item;
        }
        var title = _element.title || (_element.url || "").replace(/^https?:\/\/(www\.)?/,'').replace(/^(.{40}).+$/,'$1…'),
            url = _element.url || "",
            description = _element.description || "",
            image = _element.image || "";
        if (url && !/^https?:\/\//.test(url)) {
            url = 'http://' + url;
        }
        if (!search.isempty && !search.test(title) && !search.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            image: image,
            description: description,
            hdescription: highlight(description),
            static_url: _this.renkan.options.static_url
        });
    });
    _this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

Rkns.ResourceList.Bin.prototype.refresh = function() {
    if (this.data) {
        this.render();
    }
};

Rkns.Wikipedia = {
};

Rkns.Wikipedia.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "en";
};

Rkns.Wikipedia.Search.prototype.getBgClass = function() {
    return "Rk-Wikipedia-Search-Icon Rk-Wikipedia-Lang-" + this.lang;
};

Rkns.Wikipedia.Search.prototype.getSearchTitle = function() {
    var langs = {
        "fr": "French",
        "en": "English",
        "ja": "Japanese"
    };
    if (langs[this.lang]) {
        return this.renkan.translate("Wikipedia in ") + this.renkan.translate(langs[this.lang]);
    } else {
        return this.renkan.translate("Wikipedia") + " [" + this.lang + "]";
    }
};

Rkns.Wikipedia.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.Wikipedia.Bin(this.renkan, {
            lang: this.lang,
            search: _q
        })
    );
};

Rkns.Wikipedia.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.Wikipedia.Bin.prototype.resultTemplate = renkanJST['templates/wikipedia-bin/resulttemplate.html'];

Rkns.Wikipedia.Bin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.search = _opts.search;
    this.lang = _opts.lang || "en";
    this.title_icon_$.addClass('Rk-Wikipedia-Title-Icon Rk-Wikipedia-Lang-' + this.lang);
    this.title_$.html(this.search).addClass("Rk-Wikipedia-Title");
    this.refresh();
};

Rkns.Wikipedia.Bin.prototype.render = function(searchbase) {
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    var highlightrx = (search.isempty ? Rkns.Utils.regexpFromTextOrArray(this.search) : search);
    function highlight(_text) {
        return highlightrx.replace(_(_text).escape(), "<span class='searchmatch'>$1</span>");
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._.each(this.data.query.search, function(_result) {
        var title = _result.title,
            url = "http://" + _this.lang + ".wikipedia.org/wiki/" + encodeURI(title.replace(/ /g,"_")),
            description = Rkns.$('<div>').html(_result.snippet).text();
        if (!search.isempty && !search.test(title) && !search.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            description: description,
            hdescription: highlight(description),
            static_url: _this.renkan.options.static_url
        });
    });
    _this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

Rkns.Wikipedia.Bin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: "http://" + _this.lang + ".wikipedia.org/w/api.php?action=query&list=search&srsearch=" + encodeURIComponent(this.search) + "&format=json",
        dataType: "jsonp",
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
};
