package org.iri_research.renkan.coweb.event;

import java.util.List;
import java.util.Map;

import javax.inject.Inject;
import javax.inject.Named;

import org.coweb.CowebException;
import org.iri_research.renkan.models.Node;
import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.models.ProjectRevision;
import org.iri_research.renkan.repositories.NodesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;

@Named
public class NodeSyncEventManager extends AbstractSyncEventManager {

	private final Logger logger = LoggerFactory.getLogger(ProjectSyncEventManager.class);

	@Inject
	private NodesRepository nodesRepository;
	
	
	public NodesRepository getNodesRepository() {
		return nodesRepository;
	}

	@Override
	public boolean update(Map<String, Object> data) {

		this.logger.debug("ProjectSyncEventManager: update project");
		
		@SuppressWarnings("unchecked")
		Map<String, Object> values = (Map<String, Object>) data.get("value");
		String node_id = (String) values.get("id");
		
		this.logger.debug(String.format("update node %s", node_id));
		
		DBCollection projectCollection = this.getNodesRepository().getCollection();
		DBObject node = projectCollection.findOne(node_id);
		
		if (null == node) {
			throw new CowebException("Node update: node not found", String.format("Node %s not found", node_id));
		}
		
		boolean node_changed = false;
		// update project
		for (String fieldname : values.keySet()) {
			if(!"id".equalsIgnoreCase(fieldname) && node.containsField(fieldname))
			{
				Object new_value = values.get(fieldname);
				Object old_value = node.get(fieldname);
				if((new_value == null && old_value != null) || (new_value != null && !new_value.equals(old_value))) {
					node.put(fieldname, new_value);
					node_changed = true;
				}
			}
		}
		
		if(node_changed) {
			node.put("_id", node_id);
			WriteResult res = this.getNodesRepository().getCollection().update(new BasicDBObject("_id", node_id), node, true, false);
			
			if(!res.getLastError().ok()) {
				throw new CowebException(String.format("Error when writing node %s", node_id), res.getLastError().getErrorMessage()); 
			}
		}

		return false;
	}

	@Override
	public boolean insert(Map<String, Object> data) {
	
		// get project
		this.logger.debug("ProjectSyncEventManager: update project");
		
		@SuppressWarnings("unchecked")
		Map<String, Object> values = (Map<String, Object>) data.get("value");
		String project_id = (String) values.get("project_id");

		Project project = this.getProjectsRepository().findOne(project_id); 
		
		if (null == project) {
			throw new CowebException("node insert: project not found", String.format("Project %s not found", project_id));
		}

		String node_id = (String)values.get("id");
		
		Node node = new Node(node_id, (String)values.get("id"), (String)values.get("description"), (String)values.get("uri"), project);
		
		Integer position = (Integer)data.get("position");
		
		if(position == null || position < 0) {
			throw new CowebException("node insert: bad insert position", String.format("Bad position %s not found", position==null?"null":position.toString()));
		}
		int index = position.intValue();
		List<Node> nodes = project.getNodes();
		if(index > nodes.size()) {
			index = nodes.size();
		}
		nodes.add(index,node);

		this.getNodesRepository().save(node);
		this.getProjectsRepository().save(project);
		
		return false;
	}

	@Override
	public boolean delete(Map<String, Object> data) {
		
		
		return false;
	}

	@Override
	public boolean nullOperation(Map<String, Object> data) {
		this.logger.debug("nullOperation: NOP");
		return false;
	}

}
