(function() {
	
	var root = this;
		
	var Backbone = root.Backbone;
	
	var Rkns = root.Rkns = {};

	root.ModelView = Backbone.View.extend({
		
		events : {
			"click .show_form" : "show_form",
			"click .remove_button" : "remove_click",
		},
		
		initialize: function(options) {
			_.bindAll(this);
			this.template = _.template(options.template);
			this.model.bind("change", this.render);
			this.form_view = options.form_view;
			this.form_el = options.form_el;
			if(typeof options.getJSON === "function") {
				this.getJSON = options.getJSON;
			}
		},
		render: function() {
			$(this.el).html(this.template(this.getJSON()));
			return this;
		},
		show_form: function(evt) {
			if(typeof this.form_view !== "undefined") {
				this.form_view.render();
				$(this.form_el).empty();
				$(this.form_el).append(this.form_view.el);
			}
		},
		getJSON : function() {
			return this.model.toJSON();			
		},
		remove_click : function(evt) {
			var obj_id = $(evt.currentTarget).attr("value");
			if(typeof this.model.collection !== "undefined") {
				this.model.collection.remove(this.model);
			}
		},

	});
	
	root.ColView = Backbone.View.extend({
		initialize: function(options) {
			
			_.bindAll(this);
			this.element = options.element;
			this.element_form = options.element_form;
			this.element_form_el = options.element_form_el;
			this.rendered = false;
			
			var that = this;
			this.element_views = [];
			
			this.collection.each(function(elt) { 
				this.add(elt); 
			});
			
			this.collection.bind('add', this.add);
			this.collection.bind('remove', this.remove);
		},
		
		render : function() {
			this.rendered = true;
			var that = this;
			this.$el.empty();
			_(this.element_views).each(function(dvs){
				that.$el.append(dvs.disp.render().el);				
			});
			
			return this;
		},
		
		add : function(elt) {
			
			var fv_args = _.extend({}, this.element_form, {model: elt});			
			var fv = new FormView(fv_args);
			
			var dv_args = _.extend({}, this.element, {model: elt, tagName: 'li', form_view: fv, form_el: this.element_form_el});			
			var dv = new ModelView(dv_args);
			
			this.element_views.push({disp:dv, form:fv});
			
			if(this.rendered) {
				this.$el.append(dv.render().el);
			}
		},
			
		
		remove : function(elt) {
			var viewsToRemove = _(this.element_views).select(function(cvs) { return cvs.disp.model === elt; })[0];
			this.element_views = _(this.element_views).without(viewsToRemove);
			
			if(this.rendered) {
				viewsToRemove.disp.$el.remove();
				viewsToRemove.form.$el.remove();
			}
		},
		
		remove_click : function(evt) {
			var obj_id = $(evt.currentTarget).attr("value");
			this.collection.remove(this.collection.get(obj_id));
		}
		
	});
	
	root.FormView = Backbone.View.extend({
		events : {
			"change .form_field": "changed"
		},
		initialize: function(options) {
			_.bindAll(this);
			this.template = _.template(options.template);
			this.model.bind("change", this.render);
			if(typeof options.getJSON === "function") {
				this.getJSON = options.getJSON;
			}
		},
		render: function() {
			this.$el.html(this.template(this.getJSON()));
			return this;
		},
		changed: function(evt) {
			var value = $(evt.currentTarget).val();
			var field_name = $(evt.currentTarget).attr("name");
			if(this.model.get(field_name) != value) {
				this.model.set(field_name, value);
			}
		},
		getJSON : function() {
			return this.model.toJSON(); 
		}
	});
	
	
	root.SelectCurrentUserView = Backbone.View.extend({
		initialize: function(options) {
			_.bindAll(this);
			this.rendered = false;
			
			this.child_view_constructor = options.child_view_constructor;
			this.child_tag_name = options.child_tag_name;
			
			this.children_views = [];
			this.collection.each(this.add);
			
			this.collection.bind('add', this.add);
			this.collection.bind('remove', this.remove);
		},
		add: function(elt) {
			var child_view = new this.child_view_constructor({
				model: elt,
				tagName : this.child_tag_name
			});
			this.children_views.push(child_view);
			
			if (this.rendered) {
				this.$el.append(child_view.render().el);
			}
		},
		remove: function(elt) {
			var view_to_remove = _(this.children_views).select(function(cv) { return cv.model === elt; })[0];
			this.children_views = _(this.children_views).without(view_to_remove);
			if (this.rendered) {
				view_to_remove.$el.remove();
			}
		},
		render: function() {
			this.rendered = true;
			var that = this;
			
			this.$el.empty().html("<option value=\"\">Unknown</option>");
			
			_(this.children_views).each(function(cv){
				that.$el.append(cv.render().el);
			});
			
			return this;
		}
		
	});
	
	root.SelectUserView = Backbone.View.extend({
		initialize: function(options) {
			_.bindAll(this);
			this.model.bind("change", this.render);
		},		
		render: function() {
			this.$el.val(this.model.id).text(this.model.get("title"));
			return this;
		}
	});
	
	root.CurrentUserView = Backbone.View.extend({
		initialize : function() {
			this._select_view = new SelectCurrentUserView({
				el : this.el,
				collection : this.model.get("users"),
				child_view_constructor: SelectUserView,
				child_tag_name: "option",
			});
		},
		render: function() {
			this.$el.empty();
			this._select_view.render();
			return this;
		}
		
	});
	
	
	root.BasicListView = Backbone.View.extend({
		
		initialize: function(options) {
			_.bindAll(this);
			
			this.element_view_constructor = options.element_view_constructor;
			if(typeof options.template !== "undefined") {
				this.template = _.template(options.template);
			}
			
			this.rendered = false;
			this.element_views = [];
			this.collection.each(this.add);
			
			this.collection.bind('add', this.add);
			this.collection.bind('remove', this.remove);
			this.collection.bind('reset', this.reset);
			this.collection.bind('destroy', this.destroy);
		},
	
		render: function() {
			this.rendered = true;
			var that = this;
			this.$el.empty();
			if(typeof this.template !== "undefined") {
				var data = {};
				if(typeof this.model !== "undefined") {
					data = this.$el.model.toJSON();
				}
				this.$el.html(this.template(data));
			}
			_(this.element_views).each(function(dvs){
				that.$el.append(dvs.render().el);
			});

			return this;
		},
		
		add: function(elt) {
			var element_view = new this.element_view_constructor({model: elt});
			this.element_views.push(element_view);
			if(this.rendered) {
				this.$el.append(element_view.render().el);
			}
		},
		
		remove: function(elt) {
			var element_view = _(this.element_views).select(function(cv) {return cv.model === elt;})[0];
			this.element_views = _(this.element_views).without(element_view);
			if(this.rendered) {
				element_view.$el.remove();
			}
			
		},

		reset: function() {
			_(this.element_views).each(function(cv) {
				cv.$el.remove();
			});
			this.element_views = [];
			this.collection.each(this.add);	
		}
	
	});
	
	
	root.BasicModelView = Backbone.View.extend({
				
		initialize: function(options) {
			_.bindAll(this);
			if(typeof options.template !== "undefined") {
				this.template = _.template(options.template);
			}
			if(typeof options.getJSON === "function") {
				this.getJSON = options.getJSON;
			}
			this.model.bind("change", this.render);
		},
		render: function() {
			$(this.el).html(this.template(this.getJSON()));
			return this;
		},
		getJSON : function() {
			return this.model.toJSON();			
		}
	});
	
}).call(this);
