package org.iri_research.renkan.models;

import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;


@Document(collection="relations")
public class Relation extends AbstractRenkanModel<ObjectId> {

	@DBRef
	private Node srcNode;
	
	@DBRef
	private Node tgtNode;
	
	@DBRef
	private Project project;

	public Relation(ObjectId id, String title, String description, String uri, Node srcNode, Node tgtNode, Project project) {
		super(id,title, description, uri);
		this.srcNode = srcNode;
		this.tgtNode = tgtNode;
		this.project = project;
	}

}
