package org.iri_research.renkan.models;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="projectRevisions")
public class ProjectRevision extends AbstractRenkanModel<ObjectId> {

	@SuppressWarnings("unused")	
	private static Logger logger = LoggerFactory.getLogger(ProjectRevision.class);
	
	private int revision;
	
	@DBRef
	private Project project;
	
	private Date created;
	
	// Nodes
	private List<Node> nodes = new ArrayList<Node>();
	
	// Relations
	private List<Relation> relations = new ArrayList<Relation>();


	@SuppressWarnings("unused")
	private ProjectRevision() {
		super();
	}

	public ProjectRevision(ObjectId id, String title, String description,
			String uri, Project project, int revision, Date created) {
		super(id, title, description, uri);
		this.project = project;
		this.revision = revision;
		if(created == null) {
			this.created = new Date(System.currentTimeMillis());
		}
	}

	public int getRevision() {
		return revision;
	}
	
	public Project getProject() {
		return project;
	}
	
	public List<Node> getNodes() {
		return nodes;
	}

	public List<Relation> getRelations() {
		return relations;
	}

	public Date getCreated() {
		return created;
	}
		
}
