package org.iri_research.renkan.models;

import java.io.Serializable;


public abstract class AbstractRenkanModel<ID extends Serializable> implements IRenkanModel<ID> {
	
	public AbstractRenkanModel(ID id, String title, String description, String uri) {
		super();
		this.id = id;
		this.title = title;
		this.description = description;
		this.uri = uri;
	}
	
	protected AbstractRenkanModel() {		
	}

	protected ID id;
	protected String title;
	protected String description;
	protected String uri;
	
	@Override
	public String getTitle() {
		return this.title;
	}

	@Override
	public String getDescription() {
		return this.description;
	}

	@Override
	public String getUri() {
		return this.uri;
	}
	
	@Override
	public ID getId() {
		return this.id;
	}

}
