package org.iri_research.renkan.controller;

import java.util.HashMap;
import java.util.Map;

import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.repositories.ProjectsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;


@Controller
@RequestMapping("/")
public class RenkanController {

	private final Logger logger = LoggerFactory.getLogger(RenkanController.class);
	
	@Autowired
	private ProjectsRepository projectRepository;
	
	@RequestMapping(value="/{project_id}", method = RequestMethod.GET, produces={"text/html", "!image/*"})
	public ModelAndView renkanProject(@PathVariable(value="project_id") String project_id, @RequestHeader(value="Accept") String accept_header) throws HttpMediaTypeNotSupportedException {

		this.logger.debug("renkanProject : " + project_id + " Accept : " + accept_header!=null?accept_header:"");
		
		if(accept_header != null && accept_header.matches(".*image/.*")) {
			throw new HttpMediaTypeNotSupportedException("Do not orduce image");
		}
		
		if(project_id == null || project_id.length() == 0) {
			throw new IllegalArgumentException("RenkanContoller.renkanProject: Project id is null or empty.");
		}
		
		Project project = this.projectRepository.findOne(project_id);

		if(project == null) {
			project = new Project(project_id, "(New project)", "(Project Description)", "");
			this.projectRepository.save(project);
		}
		
		Map<String, Object> model = new HashMap<String, Object>();
		model.put("project", project);
		
		return new ModelAndView("renkanProjectEdit", model);
	}
	
	/*@RequestMapping("/test")
	public ModelAndView projectPrompt() {
		String message = "Hello world, Spring";
		
		return new ModelAndView("projectPrompt", "message", message);
	}*/
	
}
