/* Saves the Full JSON at each modification */

Rkns.jsonIO = function(_renkan, _opts) {
    var _proj = _renkan.project;
    if (typeof _opts.http_method === "undefined") {
        _opts.http_method = 'PUT';
    }
    var _load = function() {
        _proj.set({
            loadingStatus : true
        });
        Rkns.$.getJSON(_opts.url, function(_data) {
            _renkan.dataloader.load(_data);
            
            _proj.set({
                loadingStatus : false
            });
            _proj.set({
                saveStatus : 0
            });
        });
    };
    var _save = function() {
        _proj.set({
            saveStatus : 2
        });
        var _data = _proj.toJSON();
        if (!_renkan.read_only) {
            Rkns.$.ajax({
                type : _opts.http_method,
                url : _opts.url,
                contentType : "application/json",
                data : JSON.stringify(_data),
                success : function(data, textStatus, jqXHR) {
                    _proj.set({
                        saveStatus : 0
                    });
                }
            });
        }

    };
    var _thrSave = Rkns._.throttle(function() {
        setTimeout(_save, 100);
    }, 1000);
    
    //TODO: Rearrange to avoid the 2 firts PUT due to a change in the project model
    // Take car of setting up the listener correctly to listen the save action on the view
    _proj.on("add:nodes add:edges add:users add:views", function(_model) {
        _model.on("change remove", function(_model) {
            _thrSave();
        });
        _thrSave();
    });
    _proj.on("change", function() {
        if (!(_proj.changedAttributes.length === 1 && _proj
                .hasChanged('saveStatus'))) {
            _thrSave();
        }
    });

    _load();
};
