package org.iri_research.renkan.forms;

import org.iri_research.renkan.Constants;
import org.iri_research.renkan.models.Group;
import org.iri_research.renkan.repositories.GroupsRepository;
import org.iri_research.renkan.repositories.IRenkanRepository;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupForm extends RenkanForm<String, Group> {

    private String avatar;

    private GroupsRepository groupsRepository;
    
    
    public GroupForm() {
        super();
    }
    
    public GroupForm(Group model) {
        super(model);
        if (model != null) {
            this.avatar = model.getAvatar();
        }
    }

    public String getAvatar() {
        return avatar;
    }

    @Override
    protected Group getModelInstance() {
        return new Group();
   }

    @Override
    protected IRenkanRepository<Group, String> getRepository() {
        return this.groupsRepository;
    }

    public GroupsRepository getGroupsRepository() {
        return groupsRepository;
    }


    @Override
    protected void saveToModel() {
        if (this.getId() == null || this.getId().length() == 0) {
            this.model.setId(Constants.UUID_GENERATOR.generate().toString());
        }
        this.model.setAvatar(this.avatar);

    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }


    @Autowired
    public void setGroupsRepository(GroupsRepository groupsRepository) {
        this.groupsRepository = groupsRepository;
    }


}
