package org.iri_research.renkan.models;

import java.io.Serializable;

import org.iri_research.renkan.RenkanException;
import org.iri_research.renkan.RenkanRuntimeException;

public interface IRenkanModel<ID extends Serializable> {

    public ID getId();

    /**
     * Set the object id. This method must throw a RenkanException if the
     * current object id is not null
     * 
     * @param id
     * @throws RenkanRuntimeException
     *             if the current id is not null
     */
    public void setId(ID id) throws RenkanRuntimeException;

    public String getTitle();

    public String getDescription();

    public String getUri();

    public String getColor();

    public void setTitle(String title);

    public void setDescription(String description);

    public void setUri(String uri);

    public void setColor(String color);

    public String getKey(String salt) throws RenkanException;

    public boolean checkKey(String key, String salt) throws RenkanException;

}
