/* Saves the Full JSON at each modification */

Rkns.jsonIO = function(_renkan, _opts) {
    var _proj = _renkan.project;
    if (typeof _opts.http_method == "undefined") {
        _opts.http_method = 'PUT';
    }
    var _load = function() {
        Rkns.$.getJSON(_opts.url, function(_data) {
            _proj.get("users").add(_data.users);
            Rkns._(_data.nodes).each(function(_item) {
                _proj.addNode(_item);
            });
            Rkns._(_data.edges).each(function(_item) {
                _proj.addEdge(_item);
            });
        });
    }
    var _save = function() {
        var _data = {
            users: _proj.get("users").map(function(_item) {
                return {
                    id: _item.get("id"),
                    title: _item.get("title"),
                    uri: _item.get("uri"),
                    description: _item.get("description"),
                    color: _item.get("color")
                }
            }),
            nodes: _proj.get("nodes").map(function(_item) {
                return {
                    id: _item.get("id"),
                    title: _item.get("title"),
                    uri: _item.get("uri"),
                    description: _item.get("description"),
                    position: _item.get("position"),
                    created_by: _item.get("created_by").get("id")
                }
            }),
            edges: _proj.get("edges").map(function(_item) {
                return {
                    id: _item.get("id"),
                    title: _item.get("title"),
                    uri: _item.get("uri"),
                    description: _item.get("description"),
                    from: _item.get("from").get("id"),
                    to: _item.get("to").get("id"),
                    created_by: _item.get("created_by").get("id")
                }
            })
        };
        Rkns.$.ajax({
            type: _opts.http_method,
            url: _opts.url,
            contentType: "application/json",
            data: JSON.stringify(_data),
            success: function(data, textStatus, jqXHR) {
            }
        });
        
    }
    var _thrSave = Rkns._.throttle(_save, 2000);
    _load();
    _proj.on("add:nodes add:edges add:users", function(_model) {
        _model.on("change remove", function(_model) {
            _thrSave();
        });
    });
}
