/* 
 *  Copyright 2012 Institut de recherche et d'innovation 
 *  contributor(s) : Samuel Huron, Raphael Velt
 *   
 *  contact@iri.centrepompidou.fr
 *  http://www.iri.centrepompidou.fr 
 *   
 *  This software is a computer program whose purpose is to show and add annotations on a video .
 *  This software is governed by the CeCILL-C license under French law and
 *  abiding by the rules of distribution of free software. You can  use, 
 *  modify and/ or redistribute the software under the terms of the CeCILL-C
 *  license as circulated by CEA, CNRS and INRIA at the following URL
 *  "http://www.cecill.info". 
 *  
 *  The fact that you are presently reading this means that you have had
 *  knowledge of the CeCILL-C license and that you accept its terms.
*/

/* Declaring the Renkan Namespace Rkns and Default values */

Rkns = {
    _MIN_DRAG_DISTANCE: 2,
    _NODE_RADIUS: 20,
    _NODE_FONT_SIZE: 14,
    _ARROW_LENGTH: 20,
    _ARROW_WIDTH: 15,
    _RENDER: 1,
    _SAVE: 2,
    _RENDER_AND_SAVE: 3
}

Rkns.$ = jQuery;

Rkns._ = _;

Rkns.Bins = {}

Rkns.Bins._Base = function(_renkan, _opts) {
    if (typeof _renkan !== "undefined") {
        this.renkan = _renkan;
        this.renkan.$.find(".Rk-Bin-Main").hide();
        this.$ = Rkns.$('<li>')
            .addClass("Rk-Bin")
            .appendTo(_renkan.$.find(".Rk-Bin-List"));
        this.title_$ = Rkns.$('<h2>')
            .addClass("Rk-Bin-Title")
            .appendTo(this.$);
        this.main_$ = Rkns.$('<div>')
            .addClass("Rk-Bin-Main")
            .appendTo(this.$);
        this.renkan.resizeBins();
    }
}
/* Point of entry */

Rkns.Renkan = function(_opts) {
    if (typeof _opts.remotemodel !== "string") {
        _opts.remotemodel = "FullJson";
    }
    if (typeof _opts.language !== "string" || typeof Rkns.i18n[_opts.language] == "undefined") {
        _opts.language = "en";
    }
    if (typeof _opts.container !== "string") {
        _opts.container = "renkan";
    }
    if (typeof _opts.search !== "object" || !_opts.search) {
        _opts.search = [];
    }
    this.project = new Rkns.Models.Project();
    this.l10n = Rkns.i18n[_opts.language];
    if (typeof _opts.user_id !== "undefined") {
        this.current_user = _opts.user_id;
    }
    this.$ = Rkns.$("#" + _opts.container);
    this.$.html(this.template());
    this.renderer = new Rkns.Renderer.Scene(this);
    this.tabs = [];
    this.selected_bin_item = undefined;
    this.mousedown = false;
    var _this = this;
    this.$.mouseup(function() {
        _this.selected_bin_item = undefined;
    });
    if (!_opts.search.length) {
        this.$.find(".Rk-Search-Form").detach();
    } else {
        var _tmpl = Rkns._.template('<option value="<%= name %>"><%= name %></option>');
        this.$.find(".Rk-Search-Select").html(
            Rkns._(_opts.search).map(function(_name) {
                return _tmpl({name:_name});
            }).join("")
        );
    }
    this.$.find(".Rk-Search-Form").submit(function() {
        _this.tabs.push(
            new Rkns.Bins[_this.$.find(".Rk-Search-Select").val()](
                _this,
                {
                    search: _this.$.find(".Rk-Search-Input").val()
                }
            )
        );
        return false;
    });
    this.$.find(".Rk-Bins")
        .click(function(_e) {
            if (_e.target.className == "Rk-Bin-Title") {
                var _mainDiv = Rkns.$(_e.target).siblings(".Rk-Bin-Main");
                if (_mainDiv.is(":hidden")) {
                    _this.$.find(".Rk-Bin-Main").slideUp();
                    _mainDiv.slideDown();
                }
            }
        }).mousedown(function(_e) {
            var _t = Rkns.$(_e.target);
            while (!_t.is(".Rk-Bins,.Rk-Bin-Item")) {
                _t = _t.parent();
            }
            if (_t.is(".Rk-Bin-Item")) {
                _this.selected_bin_item = {
                    uri : $(_t).attr("data-uri"),
                    title : $(_t).attr("data-title"),
                    description : $(_t).attr("data-description")
                }
                return false;
            }
        });
    Rkns.$(window).resize(function() {
        _this.resizeBins();
    });
}

Rkns.Renkan.prototype.template = Rkns._.template(
    '<div class="Rk-Bins">'
    + '<form class="Rk-Search-Form"><input class="Rk-Search-Input" type="search" placeholder="Search" /><select class="Rk-Search-Select"></select></form>'
    + '<ul class="Rk-Bin-List"></ul></div><div class="Rk-Render"></div>'
);


Rkns.Renkan.prototype.resizeBins = function() {
    var _titles = this.$.find(".Rk-Bin-Title"),
        _d = _titles.length * _titles.outerHeight() + this.$.find(".Rk-Search-Form").outerHeight();
    this.$.find(".Rk-Bin-Main").css({
        height: this.$.find(".Rk-Bins").height() - _d
    });
}

/* Utility functions */

Rkns.Utils = {
    _ID_AUTO_INCREMENT : 0,
    _ID_BASE : (function(_d) {
        function pad(n){return n<10 ? '0'+n : n}
        function fillrand(n) {
            var _res = ''
            for (var i=0; i<n; i++) {
                _res += Math.floor(16*Math.random()).toString(16);
            }
            return _res;
        }
        return _d.getUTCFullYear() + '-'  
            + pad(_d.getUTCMonth()+1) + '-'  
            + pad(_d.getUTCDate()) + '-'
            + fillrand(16);
    })(new Date()),
    getUID : function(_base) {
        var _n = (++this._ID_AUTO_INCREMENT).toString(16),
            _base = (typeof _base === "undefined" ? "" : _base + "-" );
        while (_n.length < 4) {
            _n = '0' + _n
        }
        return _base + this._ID_BASE + '-' + _n;
    },
    inherit : function(_baseClass, _callbefore) {
        var _class = function() {
            if (typeof _callbefore === "function") {
                _callbefore.apply(this, Array.prototype.slice.call(arguments, 0));
            }
            if (typeof _baseClass.prototype._init !== "function") {
                _baseClass.prototype._init = function() {}
            }
            _baseClass.apply(this, Array.prototype.slice.call(arguments, 0));
            this._init.apply(this, Array.prototype.slice.call(arguments, 0));
        }
        _class.prototype = new _baseClass();
        return _class;
    }
}