
define(['jquery', 'underscore', 'requtils', 'renderer/baseeditor'], function ($, _, requtils, BaseEditor) {
    'use strict';

    var Utils = requtils.getUtils();

    /* EdgeEditor Begin */

    //var EdgeEditor = Renderer.EdgeEditor = Utils.inherit(Renderer._BaseEditor);
    var EdgeEditor = Utils.inherit(BaseEditor);

    _(EdgeEditor.prototype).extend({
        _init: function() {
          BaseEditor.prototype._init.apply(this);
          this.template = this.options.templates['templates/edgeeditor.html'];
          this.readOnlyTemplate = this.options.templates['templates/edgeeditor_readonly.html'];
        },
        draw: function() {
            var _model = this.source_representation.model,
            _from_model = _model.get("from"),
            _to_model = _model.get("to"),
            _created_by = _model.get("created_by") || Utils._USER_PLACEHOLDER(this.renkan),
            _template = (this.renderer.isEditable() ? this.template : this.readOnlyTemplate);
            this.editor_$
              .html(_template({
                edge: {
                    has_creator: !!_model.get("created_by"),
                    title: _model.get("title"),
                    uri: _model.get("uri"),
                    short_uri:  Utils.shortenText((_model.get("uri") || "").replace(/^(https?:\/\/)?(www\.)?/,'').replace(/\/$/,''),40),
                    description: _model.get("description"),
                    color: (_model.has("style") && _model.get("style").color) || _created_by.get("color"),
                    dash: _model.has("style") && _model.get("style").dash ? "checked" : "",
                    arrow: (_model.has("style") && _model.get("style").arrow) || !_model.has("style") || (typeof _model.get("style").arrow === 'undefined') ? "checked" : "",
                    thickness: (_model.has("style") && _model.get("style").thickness) || 1,
                    from_title: _from_model.get("title"),
                    to_title: _to_model.get("title"),
                    from_color: (_from_model.has("style") && _from_model.get("style").color) || (_from_model.get("created_by") || Utils._USER_PLACEHOLDER(this.renkan)).get("color"),
                    to_color: (_to_model.has("style") && _to_model.get("style").color) || (_to_model.get("created_by") || Utils._USER_PLACEHOLDER(this.renkan)).get("color"),
                    created_by_color: _created_by.get("color"),
                    created_by_title: _created_by.get("title")
                },
                renkan: this.renkan,
                shortenText: Utils.shortenText,
                options: this.options
            }));
            this.redraw();
            var _this = this,
            closeEditor = function() {
                _this.renderer.removeRepresentation(_this);
                _this.editor_$.find(".Rk-Edit-Size-Btn").off('click');
                paper.view.draw();
            };
            this.editor_$.find(".Rk-CloseX").click(closeEditor);
            this.editor_$.find(".Rk-Edit-Goto").click(function() {
                if (!_model.get("uri")) {
                    return false;
                }
            });

            if (this.renderer.isEditable()) {

                var onFieldChange = _.throttle(function() {
                    _.defer(function() {
                        if (_this.renderer.isEditable()) {
                            var _data = {
                                title: _this.editor_$.find(".Rk-Edit-Title").val()
                            };
                            if (_this.options.show_edge_editor_uri) {
                                _data.uri = _this.editor_$.find(".Rk-Edit-URI").val();
                            }
                            if (_this.options.show_node_editor_style) {
                                var dash = _this.editor_$.find(".Rk-Edit-Dash").is(':checked');
                                _data.style = _.assign( ((_model.has("style") && _.clone(_model.get("style"))) || {}), {dash: dash});
                                var arrow = _this.editor_$.find(".Rk-Edit-Arrow").is(':checked');
                                _data.style = _.assign( ((_model.has("style") && _.clone(_model.get("style"))) || {}), {arrow: arrow});
                            }
                            _this.editor_$.find(".Rk-Edit-Goto").attr("href",_data.uri || "#");
                            _model.set(_data);
                            paper.view.draw();
                        } else {
                            closeEditor();
                        }
                    });
                },500);

                this.editor_$.on("keyup", function(_e) {
                    if (_e.keyCode === 27) {
                        closeEditor();
                    }
                });

                this.editor_$.find("input").on("keyup change paste", onFieldChange);

                this.editor_$.find(".Rk-Edit-Vocabulary").change(function() {
                    var e = $(this),
                    v = e.val();
                    if (v) {
                        _this.editor_$.find(".Rk-Edit-Title").val(e.find(":selected").text());
                        _this.editor_$.find(".Rk-Edit-URI").val(v);
                        onFieldChange();
                    }
                });
                this.editor_$.find(".Rk-Edit-Direction").click(function() {
                    if (_this.renderer.isEditable()) {
                        _model.set({
                            from: _model.get("to"),
                            to: _model.get("from")
                        });
                        _this.draw();
                    } else {
                        closeEditor();
                    }
                });

                var _picker = _this.editor_$.find(".Rk-Edit-ColorPicker");

                this.editor_$.find(".Rk-Edit-ColorPicker-Wrapper").hover(
                        function(_e) {
                            _e.preventDefault();
                            _picker.show();
                        },
                        function(_e) {
                            _e.preventDefault();
                            _picker.hide();
                        }
                );

                _picker.find("li").hover(
                        function(_e) {
                            _e.preventDefault();
                            _this.editor_$.find(".Rk-Edit-Color").css("background", $(this).attr("data-color"));
                        },
                        function(_e) {
                            _e.preventDefault();
                            _this.editor_$.find(".Rk-Edit-Color").css("background", (_model.has("style") && _model.get("style").color)|| (_model.get("created_by") || Utils._USER_PLACEHOLDER(_this.renkan)).get("color"));
                        }
                ).click(function(_e) {
                    _e.preventDefault();
                    if (_this.renderer.isEditable()) {
                        _model.set("style", _.assign( ((_model.has("style") && _.clone(_model.get("style"))) || {}), {color: $(this).attr("data-color")}));
                        _picker.hide();
                        paper.view.draw();
                    } else {
                        closeEditor();
                    }
                });
                var shiftThickness = function(n) {
                    if (_this.renderer.isEditable()) {
                        var _oldThickness = ((_model.has('style') && _model.get('style').thickness) || 1),
                            _newThickness = n + _oldThickness;
                        if(_newThickness < 1 ) {
                            _newThickness = 1;
                        }
                        else if (_newThickness > _this.options.node_stroke_witdh_scale) {
                            _newThickness = _this.options.node_stroke_witdh_scale;
                        }
                        if (_newThickness !== _oldThickness) {
                            _this.editor_$.find("#Rk-Edit-Thickness-Value").text(_newThickness);
                            _model.set("style", _.assign( ((_model.has("style") && _.clone(_model.get("style"))) || {}), {thickness: _newThickness}));
                            paper.view.draw();
                        }
                    }
                    else {
                        closeEditor();
                    }
                };

                this.editor_$.find("#Rk-Edit-Thickness-Down").click(function() {
                    shiftThickness(-1);
                    return false;
                });
                this.editor_$.find("#Rk-Edit-Thickness-Up").click(function() {
                    shiftThickness(1);
                    return false;
                });
            }
        },
        redraw: function() {
            if (this.options.popup_editor){
                var _coords = this.source_representation.paper_coords;
                Utils.drawEditBox(this.options, _coords, this.editor_block, 5, this.editor_$);
            }
            this.editor_$.show();
            paper.view.draw();
        }
    }).value();

    /* EdgeEditor End */

    return EdgeEditor;

});
