# -*- coding: utf-8 -*-
import os
import sys

from setuptools import setup, find_packages

# Dynamically calculate the version based on django.VERSION.
version = __import__('renkanmanager').get_version()

def launch_setup(script_name, script_args):


    data_files = []

    root_dir = os.path.dirname(__file__)
    if root_dir != '':
        os.chdir(root_dir)
    source_dir = 'renkanmanager'


    for dirpath, dirnames, filenames in os.walk(source_dir):
        # Ignore dirnames that start with '.'
        for i, dirname in enumerate(dirnames):
            if dirname.startswith('.') : del dirnames[i]
        if dirpath.endswith('/__pycache__'):
            data_files.append([dirpath, [dirpath,]])
            continue
        if filenames and '__init__.py' not in filenames:
            data_files.append([dirpath, [os.path.join(dirpath, f) for f in filenames]])
        if filenames and dirpath.endswith('/migrations'):
            data_files.append([dirpath, [os.path.join(dirpath, f) for f in filenames if f.endswith('.sql')]])

    #write MANIFEST.in

    with open("MANIFEST.in", "w") as m:
        m.write("include MANIFEST.in\n")
        for entry in data_files:
            file_list = entry[1]
            for filename in file_list:
                if filename.endswith('/__pycache__'):
                    m.write("exclude %s/*\n" % (filename))
                else:
                    m.write("include %s\n" % (filename))

    setup(
        script_name = script_name,
        script_args = script_args,
        name='renkanmanager',
        version=version,
        url='http://renkan.iri-research.org/',
        author='I.R.I.',
        author_email='contact@iri-research.org',
        description=('Basic Django module for saving renkan'),
        license='CECILL-B',
        packages=find_packages(),
        include_package_data=True,
        zip_safe=False,
        install_requires = [
            'Django>=1.9',
            'djangorestframework>=3.3',
            'easy-thumbnails>=2.3',
            'pytz'
        ],
        classifiers=[
            'Development Status :: 3 - Alpha',
            'Environment :: Web Environment',
            'Framework :: Django',
            'Intended Audience :: Developers',
            'License :: OSI Approved :: CECILL License',
            'Operating System :: OS Independent',
            'Programming Language :: Python',
            'Programming Language :: Python :: 2',
            'Programming Language :: Python :: 2.7',
            'Topic :: Internet :: WWW/HTTP',
            'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
            'Topic :: Internet :: WWW/HTTP :: WSGI',
            'Topic :: Software Development :: Libraries :: Python Modules',
        ],
    )

if __name__ == "__main__":

    script_name = os.path.basename(sys.argv[0])
    script_args = sys.argv[1:]

    launch_setup(script_name, script_args)
