package org.iri_research.renkan.forms;

import java.util.HashSet;
import java.util.Set;

import org.iri_research.renkan.Constants;
import org.iri_research.renkan.models.Group;
import org.iri_research.renkan.repositories.GroupsRepository;
import org.iri_research.renkan.repositories.IRenkanRepository;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupForm extends RenkanForm<String, Group> {

    private String avatar;
    private Set<String> users;

    private GroupsRepository groupsRepository;
    
    
    public GroupForm() {
        super();
    }
    
    public GroupForm(Group model) {
        super(model);
        if (model != null) {
            this.avatar = model.getAvatar();
            this.setUsers(new HashSet<>(model.getUsers()));
            if(model.getUsers() != null) {
                this.getUsers().addAll(model.getUsers());
            }
        }
    }

    public String getAvatar() {
        return avatar;
    }

    @Override
    protected Group getModelInstance() {
        return new Group();
   }

    @Override
    protected IRenkanRepository<Group, String> getRepository() {
        return this.groupsRepository;
    }

    public GroupsRepository getGroupsRepository() {
        return groupsRepository;
    }


    @Override
    protected void saveToModel() {
        if (this.getId() == null || this.getId().length() == 0) {
            this.model.setId(Constants.UUID_GENERATOR.generate().toString());
        }
        this.model.setAvatar(this.avatar);
        if(this.getUsers() != null) {
            this.groupsRepository.setUsersList(model, this.getUsers());
        }
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }


    @Autowired
    public void setGroupsRepository(GroupsRepository groupsRepository) {
        this.groupsRepository = groupsRepository;
    }
    
    public Set<String> getUsers() {
        return users;
    }

    public void setUsers(Set<String> users) {
        this.users = users;
    }


}
