<?php

    require_once(realpath(dirname(__FILE__) . "/../resources/config.php"));

    require_once(LIBRARY_PATH . "/templateFunctions.php");
    require_once(LIBRARY_PATH . "/utilsFunctions.php");
    require_once(LIBRARY_PATH . "/renkanFunctions.php");
    require_once(LIBRARY_PATH . "/dbFunctions.php");

    if ($_SERVER['REQUEST_METHOD'] === 'PUT' || $_SERVER['REQUEST_METHOD'] === 'POST') {

        //TODO implement CSRF with https://github.com/BKcore/NoCSRF for example
        $renkanId = genUuid4();
        $title = isset($_POST['title']) ? $_POST['title'] : "";
        if(empty($title)) {
            $title = "new Renkan";
        }

        $description = isset($_POST['description']) ? $_POST['description'] : "New renkan";

        insertProject($renkanId, $title, emptyRenkan($title, $description, $renkanId));

        header('Location: '.selfURL()."?renkanId=$renkanId");
        die();
    }

    $variables = ['config' => $config, 'renkanId' => $_GET['renkanId']];
    $css = [
        'static/lib/renkan/css/renkan.css'
    ];

    renderLayoutWithContentFile("renkan_edit.php", $variables, $css);
