/*
 * Decompiled with CFR 0.152.
 */
package org.coweb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.coweb.ServiceHandler;
import org.coweb.SessionHandler;
import org.coweb.SessionManager;

public abstract class SessionModerator {
    private static final Logger log = Logger.getLogger(SessionHandler.class.getName());
    private static final String DefaultImpl = "org.coweb.DefaultSessionModerator";
    private static HashMap<String, SessionModerator> instancesMap = new HashMap();
    protected SessionHandler sessionHandler = null;
    protected LocalSession localSession = null;
    protected ServerSession serverSession = null;
    private Set<CollabInterface> collabInterfaces;

    protected SessionModerator() {
    }

    protected SessionModerator(SessionHandler sessionHandler) {
    }

    public static synchronized SessionModerator getInstance(SessionHandler sessionHandler, String classStr, String confKey) {
        SessionModerator mod = instancesMap.get(confKey);
        if (null == mod) {
            if (classStr == null) {
                classStr = DefaultImpl;
            }
            try {
                Class<SessionModerator> c = Class.forName(classStr).asSubclass(SessionModerator.class);
                mod = c.newInstance();
                mod.init(sessionHandler);
                instancesMap.put(confKey, mod);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            mod.updateSessionHandler(sessionHandler);
        }
        return mod;
    }

    private void init(SessionHandler sessionHandler) {
        this.collabInterfaces = new HashSet<CollabInterface>();
        this.sessionHandler = sessionHandler;
        BayeuxServer server = SessionManager.getInstance().getBayeux();
        String sessionId = sessionHandler.getSessionId();
        this.localSession = server.newLocalSession(sessionId);
        this.localSession.setAttribute("sessionid", (Object)sessionId);
        this.localSession.handshake();
        this.serverSession = this.localSession.getServerSession();
        this.setSessionAttribute("sessionid", sessionId);
        this.setSessionAttribute("username", "moderator");
    }

    void updateSessionHandler(SessionHandler handler) {
        this.sessionHandler = handler;
        this.setSessionAttribute("sessionid", handler.getSessionId());
    }

    public LocalSession getLocalSession() {
        return this.localSession;
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    public void setSessionAttribute(String key, Object val) {
        this.localSession.setAttribute(key, val);
        this.serverSession.setAttribute(key, val);
    }

    public abstract void onSync(String var1, Map<String, Object> var2);

    public abstract Map<String, Object> getLateJoinState();

    public abstract boolean canClientJoinSession(String var1, Map<String, Object> var2);

    public abstract void onClientJoinSession(String var1);

    public abstract void onClientLeaveSession(String var1);

    public abstract boolean canClientSubscribeService(String var1, String var2);

    public abstract boolean canClientMakeServiceRequest(String var1, String var2, Map<String, Object> var3);

    public abstract void onServiceResponse(String var1, Map<String, Object> var2, boolean var3, boolean var4);

    public abstract void onSessionEnd();

    void endSession() {
        for (CollabInterface ci : this.collabInterfaces) {
            this.serverSession.removeListener((ServerSession.ServerSessionListener)ci);
        }
        this.collabInterfaces.clear();
        this.sessionHandler = null;
        this.onSessionEnd();
    }

    public abstract void onSessionReady();

    public CollabInterface initCollab(String collabId) {
        CollabInterface ci = new CollabInterface(this, collabId);
        this.serverSession.addListener((ServerSession.ServerSessionListener)ci);
        this.collabInterfaces.add(ci);
        return ci;
    }

    public static class CollabInterface
    implements ServerSession.MessageListener {
        private SessionModerator moderator;
        private String collabId;
        private AtomicInteger serviceId;

        private CollabInterface(SessionModerator mod, String collabId) {
            this.moderator = mod;
            this.collabId = collabId;
            this.serviceId = new AtomicInteger(0);
        }

        public void subscribeService(String svcName) {
            this.moderator.sessionHandler.subscribeModeratorToService(svcName);
        }

        public boolean onMessage(ServerSession to, ServerSession from, ServerMessage message) {
            if (ServiceHandler.isServiceMessage((Message)message)) {
                String svcName = ServiceHandler.getServiceNameFromMessage((Message)message);
                Map data = message.getDataAsMap();
                Boolean error = (Boolean)data.get("error");
                if (null == error) {
                    error = false;
                }
                data = (Map)data.get("value");
                this.moderator.onServiceResponse(svcName, data, error, ServiceHandler.isPublicBroadcast((Message)message));
            } else {
                log.warning("CollabInterface received message it doesn't understand: " + message);
            }
            return true;
        }

        public void sendSync(String name, Object value, String type, int position) {
            name = "coweb.sync." + name + "." + this.collabId;
            this.moderator.sessionHandler.publishModeratorSync(name, value, type, position);
        }

        public void postService(String service, Map<String, Object> params) {
            int id = this.serviceId.getAndIncrement();
            String topic = "coweb.service.request." + service + "_" + id + "." + this.collabId;
            this.moderator.sessionHandler.postModeratorService(service, topic, params);
        }
    }
}

