package org.iri_research.renkan.forms;

import java.util.Date;

import org.iri_research.renkan.Constants;
import org.iri_research.renkan.models.User;
import org.iri_research.renkan.repositories.IRenkanRepository;
import org.iri_research.renkan.repositories.UsersRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserForm extends RenkanForm<String, User> {

    @Autowired
    private UsersRepository usersRepository;

    public UserForm() {
        super();
    }

    public UserForm(User model) {
        super(model);
        if (model != null) {
            this.avatar = model.getAvatar();
            this.credentialExpirationDate = model.getCredentialExpirationDate();
            this.email = model.getEmail();
            this.expirationDate = model.getExpirationDate();
            this.enabled = model.isEnabled();
            this.locked = model.isLocked();
        }
    }

    private String avatar;
    private String email;
    private Date credentialExpirationDate;
    private Date expirationDate;
    private boolean enabled;
    private boolean locked;

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Date getCredentialExpirationDate() {
        return credentialExpirationDate;
    }

    public void setCredentialExpirationDate(Date credentialExpirationDate) {
        this.credentialExpirationDate = credentialExpirationDate;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLocked() {
        return locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public UsersRepository getUsersRepository() {
        return usersRepository;
    }

    @Override
    protected void saveToModel() {
        if (this.getId() == null || this.getId().length() == 0) {
            this.model.setId(Constants.UUID_GENERATOR.generate().toString());
        }
        this.model.setAvatar(this.avatar);
        this.model.setEmail(this.email);
        this.model.setCredentialExpirationDate(this.credentialExpirationDate);
        this.model.setExpirationDate(this.expirationDate);
        this.model.setEnabled(this.enabled);
        this.model.setLocked(this.locked);

    }

    @Override
    protected IRenkanRepository<User, String> getRepository() {
        return this.usersRepository;
    }

    @Override
    protected User getModelInstance() {
        return new User();
    }

    @Autowired
    public void setUsersRepository(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

}
