
define(['jquery', 'underscore'], function ($, _) {
    'use strict';

    /* Rkns.Renderer._BaseRepresentation Class */

    /* In Renkan, a "Representation" is a sort of ViewModel (in the MVVM paradigm) and bridges the gap between
     * models (written with Backbone.js) and the view (written with Paper.js)
     * Renkan's representations all inherit from Rkns.Renderer._BaseRepresentation '*/

    var _BaseRepresentation = function(_renderer, _model) {
        if (typeof _renderer !== "undefined") {
            this.renderer = _renderer;
            this.renkan = _renderer.renkan;
            this.project = _renderer.renkan.project;
            this.options = _renderer.renkan.options;
            this.model = _model;
            if (this.model) {
                var _this = this;
                this._changeBinding = function() {
                    _this.redraw();
                };
                this._removeBinding = function() {
                    _renderer.removeRepresentation(_this);
                    _(function() {
                        _renderer.redraw();
                    }).defer();
                };
                this._selectBinding = function() {
                    _this.select();
                };
                this._unselectBinding = function() {
                    _this.unselect();
                };
                this.model.on("change", this._changeBinding );
                this.model.on("remove", this._removeBinding );
                this.model.on("select", this._selectBinding );
                this.model.on("unselect", this._unselectBinding );
            }
        }
    };

    /* Rkns.Renderer._BaseRepresentation Methods */

    _(_BaseRepresentation.prototype).extend({
        _super: function(_func) {
            return _BaseRepresentation.prototype[_func].apply(this, Array.prototype.slice.call(arguments, 1));
        },
        redraw: function() {},
        moveTo: function() {},
        show: function() { return "BaseRepresentation.show"; },
        hide: function() {},
        select: function() {
            if (this.model) {
                this.model.trigger("selected");
            }
        },
        unselect: function() {
            if (this.model) {
                this.model.trigger("unselected");
            }
        },
        highlight: function() {},
        unhighlight: function() {},
        mousedown: function() {},
        mouseup: function() {
            if (this.model) {
                this.model.trigger("clicked");
            }
        },
        destroy: function() {
            if (this.model) {
                this.model.off("change", this._changeBinding );
                this.model.off("remove", this._removeBinding );
                this.model.off("select", this._selectBinding );
                this.model.off("unselect", this._unselectBinding );
            }
        }
    });

    /* End of Rkns.Renderer._BaseRepresentation Class */

    return _BaseRepresentation;

});
