Rkns.randomData = function(_renkan, _opts) {
    _opts = _opts || {};
    _opts.user_count = _opts.user_count || 5;
    _opts.node_count = _opts.node_count || 20;
    _opts.edge_count = _opts.edge_count || 2 * _opts.node_count;
    _opts.user_colors = _opts.user_colors || ["#ff0000", "#008000", "#0000ff", "#808000", "#808080", "#c000c0", "#00c0c0"];
    var _proj = _renkan.project;
    for (var i = 0; i < _opts.user_count; i++) {
        _proj.addUser({
            id: "user-"+i,
            title: "User #"+(1+i),
            color: _opts.user_colors[i]
        });
    }
    for (var i = 0; i < _opts.node_count; i++) {
        _proj.addNode({
            id: "node-"+i,
            title: "Node #"+(1+i),
            created_by: "user-" + Math.floor(_opts.user_count*Math.random()),
            position: {
                x: 300 * Math.cos(2 * Math.PI * i / _opts.node_count),
                y: 300 * Math.sin(2 * Math.PI * i / _opts.node_count)
            }
        });
    }
    for (var i = 0; i < _opts.node_count; i++) {
        var _from, _to;
        _from = _to = Math.floor(_opts.node_count*Math.random());
        while(_from === _to) {
            _to = Math.floor(_opts.node_count*Math.random());
        }
        _proj.addEdge({
            id: "edge-"+i,
            title: "Edge #"+(1+i),
            created_by: "user-" + Math.floor(_opts.user_count*Math.random()),
            from: "node-" + _from,
            to: "node-" + _to
        });
    }
    _renkan.current_user = "user-0";
};
